/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

@OSGiBeanProperties(service={InfrastructureUtil.class})
public class InfrastructureUtil {
    private static final Log _log = LogFactoryUtil.getLog(InfrastructureUtil.class);
    private static DataSource _dataSource;
    private static Session _mailSession;
    private static final DefaultNoticeableFuture<Object> _sessionFactoryDefaultNoticeableFuture;
    private static final DefaultNoticeableFuture<Object> _transactionManagerDefaultNoticeableFuture;

    public static DataSource getDataSource() {
        return _dataSource;
    }

    public static Session getMailSession() {
        if (_mailSession == null) {
            _mailSession = InfrastructureUtil._createMailSession();
        }
        return _mailSession;
    }

    public static Object getSessionFactory() {
        try {
            return _sessionFactoryDefaultNoticeableFuture.get();
        }
        catch (Exception exception) {
            return ReflectionUtil.throwException(exception);
        }
    }

    public static Object getTransactionManager() {
        try {
            return _transactionManagerDefaultNoticeableFuture.get();
        }
        catch (Exception exception) {
            return ReflectionUtil.throwException(exception);
        }
    }

    public static void setDataSource(DataSource dataSource) {
        _dataSource = dataSource;
    }

    public static void setSessionFactory(Object sessionFactory) {
        _sessionFactoryDefaultNoticeableFuture.set(sessionFactory);
    }

    public static void setTransactionManager(Object transactionManager) {
        _transactionManagerDefaultNoticeableFuture.set(transactionManager);
    }

    private static Session _createMailSession() {
        Properties properties = PropsUtil.getProperties("mail.session.", true);
        String jndiName = properties.getProperty("jndi.name");
        if (Validator.isNotNull(jndiName)) {
            try {
                Properties jndiEnvironmentProperties = PropsUtil.getProperties("jndi.environment.", true);
                InitialContext context = new InitialContext(jndiEnvironmentProperties);
                return (Session)JNDIUtil.lookup((Context)context, (String)jndiName);
            }
            catch (Exception exception) {
                _log.error("Unable to lookup " + jndiName, exception);
            }
        }
        return Session.getInstance((Properties)properties);
    }

    static {
        _sessionFactoryDefaultNoticeableFuture = new DefaultNoticeableFuture();
        _transactionManagerDefaultNoticeableFuture = new DefaultNoticeableFuture();
    }
}

