/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.soy.builder.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.soy.builder.commands.BaseSoyJsCommand;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@Parameters(commandDescription="Wrap Soy templates into AlloyUI modules.", commandNames={"wrap-alloy-template"})
public class WrapSoyAlloyTemplateCommand
extends BaseSoyJsCommand {
    @Parameter(description="The AlloyUI module name.", names={"--module-name"}, required=true)
    private String _moduleName;
    @Parameter(description="The Soy template namespace.", names={"--namespace"}, required=true)
    private String _namespace;

    @Override
    public void execute(Path path) throws IOException {
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        String namespace = this.getNamespace();
        content = content.replace("(typeof " + namespace + " == 'undefined') { var " + namespace + " = {}; }", "(typeof " + namespace + " == 'undefined') { window." + namespace + " = {}; }");
        content = this.getWrapperHeader() + content + this.getWrapperFooter();
        Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public void setModuleName(String moduleName) {
        this._moduleName = moduleName;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    protected String getWrapperFooter() {
        return "}, '', {requires: ['soyutils']});";
    }

    protected String getWrapperHeader() {
        return "AUI.add('" + this.getModuleName() + "', function(A) {";
    }
}

