/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.uad.constants.PortalUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseRepositoryEntryUADAnonymizer
extends DynamicQueryUADAnonymizer<RepositoryEntry> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected RepositoryEntryLocalService repositoryEntryLocalService;

    public void autoAnonymize(RepositoryEntry repositoryEntry, long userId, User anonymousUser) throws PortalException {
        if (repositoryEntry.getUserId() == userId) {
            repositoryEntry.setUserId(anonymousUser.getUserId());
            repositoryEntry.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(repositoryEntry, anonymousUser);
        }
        this.repositoryEntryLocalService.updateRepositoryEntry(repositoryEntry);
    }

    public void delete(RepositoryEntry repositoryEntry) throws PortalException {
        this.repositoryEntryLocalService.deleteRepositoryEntry(repositoryEntry);
    }

    public Class<RepositoryEntry> getTypeClass() {
        return RepositoryEntry.class;
    }

    protected void autoAnonymizeAssetEntry(RepositoryEntry repositoryEntry, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(repositoryEntry);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.repositoryEntryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return PortalUADConstants.USER_ID_FIELD_NAMES_REPOSITORY_ENTRY;
    }

    protected AssetEntry fetchAssetEntry(RepositoryEntry repositoryEntry) {
        return this.assetEntryLocalService.fetchEntry(RepositoryEntry.class.getName(), repositoryEntry.getRepositoryEntryId());
    }
}

