/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.uad.constants.PortalUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the repository entry UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link RepositoryEntryUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseRepositoryEntryUADAnonymizer
	extends DynamicQueryUADAnonymizer<RepositoryEntry> {

	@Override
	public void autoAnonymize(
			RepositoryEntry repositoryEntry, long userId, User anonymousUser)
		throws PortalException {

		if (repositoryEntry.getUserId() == userId) {
			repositoryEntry.setUserId(anonymousUser.getUserId());
			repositoryEntry.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(repositoryEntry, anonymousUser);
		}

		repositoryEntryLocalService.updateRepositoryEntry(repositoryEntry);
	}

	@Override
	public void delete(RepositoryEntry repositoryEntry) throws PortalException {
		repositoryEntryLocalService.deleteRepositoryEntry(repositoryEntry);
	}

	@Override
	public Class<RepositoryEntry> getTypeClass() {
		return RepositoryEntry.class;
	}

	protected void autoAnonymizeAssetEntry(
		RepositoryEntry repositoryEntry, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(repositoryEntry);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return repositoryEntryLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return PortalUADConstants.USER_ID_FIELD_NAMES_REPOSITORY_ENTRY;
	}

	protected AssetEntry fetchAssetEntry(RepositoryEntry repositoryEntry) {
		return assetEntryLocalService.fetchEntry(
			RepositoryEntry.class.getName(),
			repositoryEntry.getRepositoryEntryId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected RepositoryEntryLocalService repositoryEntryLocalService;

}