/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.uad.constants.PortalUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the system event UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link SystemEventUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseSystemEventUADAnonymizer
	extends DynamicQueryUADAnonymizer<SystemEvent> {

	@Override
	public void autoAnonymize(
			SystemEvent systemEvent, long userId, User anonymousUser)
		throws PortalException {

		if (systemEvent.getUserId() == userId) {
			systemEvent.setUserId(anonymousUser.getUserId());
			systemEvent.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(systemEvent, anonymousUser);
		}

		systemEventLocalService.updateSystemEvent(systemEvent);
	}

	@Override
	public void delete(SystemEvent systemEvent) throws PortalException {
		systemEventLocalService.deleteSystemEvent(systemEvent);
	}

	@Override
	public Class<SystemEvent> getTypeClass() {
		return SystemEvent.class;
	}

	protected void autoAnonymizeAssetEntry(
		SystemEvent systemEvent, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(systemEvent);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return systemEventLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return PortalUADConstants.USER_ID_FIELD_NAMES_SYSTEM_EVENT;
	}

	protected AssetEntry fetchAssetEntry(SystemEvent systemEvent) {
		return assetEntryLocalService.fetchEntry(
			SystemEvent.class.getName(), systemEvent.getSystemEventId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected SystemEventLocalService systemEventLocalService;

}