/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.uad.constants.PortalUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseRepositoryUADAnonymizer
extends DynamicQueryUADAnonymizer<Repository> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected RepositoryLocalService repositoryLocalService;

    public void autoAnonymize(Repository repository, long userId, User anonymousUser) throws PortalException {
        if (repository.getUserId() == userId) {
            repository.setUserId(anonymousUser.getUserId());
            repository.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(repository, anonymousUser);
        }
        this.repositoryLocalService.updateRepository(repository);
    }

    public void delete(Repository repository) throws PortalException {
        this.repositoryLocalService.deleteRepository(repository);
    }

    public Class<Repository> getTypeClass() {
        return Repository.class;
    }

    protected void autoAnonymizeAssetEntry(Repository repository, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(repository);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.repositoryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return PortalUADConstants.USER_ID_FIELD_NAMES_REPOSITORY;
    }

    protected AssetEntry fetchAssetEntry(Repository repository) {
        return this.assetEntryLocalService.fetchEntry(Repository.class.getName(), repository.getRepositoryId());
    }
}

