/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.uad.constants.PortalUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSystemEventUADAnonymizer
extends DynamicQueryUADAnonymizer<SystemEvent> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected SystemEventLocalService systemEventLocalService;

    public void autoAnonymize(SystemEvent systemEvent, long userId, User anonymousUser) throws PortalException {
        if (systemEvent.getUserId() == userId) {
            systemEvent.setUserId(anonymousUser.getUserId());
            systemEvent.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(systemEvent, anonymousUser);
        }
        this.systemEventLocalService.updateSystemEvent(systemEvent);
    }

    public void delete(SystemEvent systemEvent) throws PortalException {
        this.systemEventLocalService.deleteSystemEvent(systemEvent);
    }

    public Class<SystemEvent> getTypeClass() {
        return SystemEvent.class;
    }

    protected void autoAnonymizeAssetEntry(SystemEvent systemEvent, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(systemEvent);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.systemEventLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return PortalUADConstants.USER_ID_FIELD_NAMES_SYSTEM_EVENT;
    }

    protected AssetEntry fetchAssetEntry(SystemEvent systemEvent) {
        return this.assetEntryLocalService.fetchEntry(SystemEvent.class.getName(), systemEvent.getSystemEventId());
    }
}

