/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.uad.anonymizer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.uad.constants.PortalUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BasePortletItemUADAnonymizer
extends DynamicQueryUADAnonymizer<PortletItem> {
    @Reference
    protected PortletItemLocalService portletItemLocalService;

    public void autoAnonymize(PortletItem portletItem, long userId, User anonymousUser) throws PortalException {
        if (portletItem.getUserId() == userId) {
            portletItem.setUserId(anonymousUser.getUserId());
            portletItem.setUserName(anonymousUser.getFullName());
        }
        this.portletItemLocalService.updatePortletItem(portletItem);
    }

    public void delete(PortletItem portletItem) throws PortalException {
        this.portletItemLocalService.deletePortletItem(portletItem);
    }

    public Class<PortletItem> getTypeClass() {
        return PortletItem.class;
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.portletItemLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return PortalUADConstants.USER_ID_FIELD_NAMES_PORTLET_ITEM;
    }
}

