/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.uad.anonymizer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.uad.constants.PortalUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseRepositoryUADAnonymizer
extends DynamicQueryUADAnonymizer<Repository> {
    @Reference
    protected RepositoryLocalService repositoryLocalService;

    public void autoAnonymize(Repository repository, long userId, User anonymousUser) throws PortalException {
        if (repository.getUserId() == userId) {
            repository.setUserId(anonymousUser.getUserId());
            repository.setUserName(anonymousUser.getFullName());
        }
        this.repositoryLocalService.updateRepository(repository);
    }

    public void delete(Repository repository) throws PortalException {
        this.repositoryLocalService.deleteRepository(repository);
    }

    public Class<Repository> getTypeClass() {
        return Repository.class;
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.repositoryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return PortalUADConstants.USER_ID_FIELD_NAMES_REPOSITORY;
    }
}

