/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.live;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.upgrade.live.LiveUpgradeProcess;

public class LiveUpgradeProcessFactory {
    public static LiveUpgradeProcess addColumns(String ... columnDefinitions) {
        return (tableName, liveUpgradeSchemaDiff) -> {
            UpgradeProcess upgradeProcess = UpgradeProcessFactory.addColumns((String)tableName, (String[])columnDefinitions);
            upgradeProcess.upgrade();
            liveUpgradeSchemaDiff.recordAddColumns(columnDefinitions);
        };
    }

    public static LiveUpgradeProcess alterColumnName(String oldColumnName, String newColumnDefinition) {
        return (tableName, liveUpgradeSchemaDiff) -> {
            UpgradeProcess upgradeProcess = UpgradeProcessFactory.alterColumnName((String)tableName, (String)oldColumnName, (String)newColumnDefinition);
            upgradeProcess.upgrade();
            liveUpgradeSchemaDiff.recordAlterColumnName(oldColumnName, newColumnDefinition);
        };
    }

    public static LiveUpgradeProcess alterColumnType(String columnName, String newColumnType) {
        return (tableName, liveUpgradeSchemaDiff) -> {
            UpgradeProcess upgradeProcess = UpgradeProcessFactory.alterColumnType((String)tableName, (String)columnName, (String)newColumnType);
            upgradeProcess.upgrade();
            liveUpgradeSchemaDiff.recordAlterColumnType(columnName, newColumnType);
        };
    }

    public static LiveUpgradeProcess dropColumns(String ... columnNames) {
        return (tableName, liveUpgradeSchemaDiff) -> {
            UpgradeProcess upgradeProcess = UpgradeProcessFactory.dropColumns((String)tableName, (String[])columnNames);
            upgradeProcess.upgrade();
            liveUpgradeSchemaDiff.recordDropColumns(columnNames);
        };
    }
}

