/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.live;

import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiveUpgradeSchemaDiff {
    private static final Pattern _columnDefaultClausePattern = Pattern.compile(".*DEFAULT ((?:'[^']+')|(?:\\S+)) NOT NULL", 2);
    private final DBInspector _dbInspector;
    private final Map<String, Column> _resultColumnsMap = new HashMap<String, Column>();

    public LiveUpgradeSchemaDiff(Connection connection, String tableName) throws Exception {
        this._dbInspector = new DBInspector(connection);
        try (ResultSet resultSet = this._dbInspector.getColumnsResultSet(tableName);){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                this._resultColumnsMap.put(columnName, new Column(columnName, false));
            }
        }
    }

    public Map<String, String> getResultColumnNamesMap() {
        HashMap<String, String> resultColumnNamesMap = new HashMap<String, String>();
        for (Column column : this._resultColumnsMap.values()) {
            if (column.isAdded()) continue;
            resultColumnNamesMap.put(column.getOldColumnName(), column.getNewColumnName());
        }
        return resultColumnNamesMap;
    }

    public Map<String, String> getResultDefaultValuesMap() {
        HashMap<String, String> defaultValuesMap = new HashMap<String, String>();
        for (Column column : this._resultColumnsMap.values()) {
            if (column.getDefaultValue() == null) continue;
            defaultValuesMap.put(column.getNewColumnName(), column.getDefaultValue());
        }
        return defaultValuesMap;
    }

    public void recordAddColumns(String ... columnDefinitions) throws Exception {
        for (String columnDefinition : columnDefinitions) {
            String columnName = this._dbInspector.normalizeName(StringUtil.extractFirst((String)columnDefinition, (String)" "));
            if (this._resultColumnsMap.containsKey(columnName)) {
                throw new IllegalArgumentException("Column " + columnName + " already exists");
            }
            String defaultValue = this._getColumnDefaultValue(columnDefinition.substring(columnDefinition.indexOf(" ") + 1));
            if (Validator.isNull((String)defaultValue)) {
                defaultValue = null;
            }
            this._resultColumnsMap.put(columnName, new Column(columnName, defaultValue, true));
        }
    }

    public void recordAlterColumnName(String oldColumnName, String newColumnDefinition) throws Exception {
        oldColumnName = this._dbInspector.normalizeName(oldColumnName);
        String newColumnName = this._dbInspector.normalizeName(StringUtil.extractFirst((String)newColumnDefinition, (String)" "));
        Column column = this._resultColumnsMap.remove(oldColumnName);
        if (column == null) {
            throw new IllegalArgumentException("Column " + oldColumnName + " does not exist");
        }
        if (this._resultColumnsMap.containsKey(newColumnName)) {
            throw new IllegalArgumentException("Column " + newColumnName + " already exists");
        }
        column.setNewColumnName(newColumnName);
        this._resultColumnsMap.put(newColumnName, column);
    }

    public void recordAlterColumnType(String columnName, String newColumnType) throws Exception {
        Column column = this._resultColumnsMap.get(columnName = this._dbInspector.normalizeName(columnName));
        if (column == null) {
            throw new IllegalArgumentException("Column " + columnName + " does not exist");
        }
        String defaultValue = this._getColumnDefaultValue(newColumnType);
        if (Validator.isNotNull((String)defaultValue)) {
            column.setDefaultValue(defaultValue);
        }
    }

    public void recordDropColumns(String ... columnNames) throws SQLException {
        for (String columnName : columnNames) {
            Column column = this._resultColumnsMap.remove(columnName = this._dbInspector.normalizeName(columnName));
            if (column != null) continue;
            throw new IllegalArgumentException("Column " + columnName + " does not exist");
        }
    }

    private String _getColumnDefaultValue(String columnType) {
        Matcher matcher = _columnDefaultClausePattern.matcher(columnType);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static class Column {
        private final boolean _added;
        private String _defaultValue;
        private String _newColumnName;
        private final String _oldColumnName;

        public Column(String columnName, boolean added) {
            this(columnName, null, added);
        }

        public Column(String columnName, String defaultValue, boolean added) {
            this._defaultValue = defaultValue;
            this._added = added;
            this._newColumnName = columnName;
            this._oldColumnName = columnName;
        }

        public String getDefaultValue() {
            return this._defaultValue;
        }

        public String getNewColumnName() {
            return this._newColumnName;
        }

        public String getOldColumnName() {
            return this._oldColumnName;
        }

        public boolean isAdded() {
            return this._added;
        }

        public void setDefaultValue(String defaultValue) {
            this._defaultValue = defaultValue;
        }

        public void setNewColumnName(String newColumnName) {
            this._newColumnName = newColumnName;
        }
    }
}

