/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.release;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.model.dao.ReleaseDAO;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseUpgradeServiceModuleRelease
extends UpgradeProcess {
    public void upgrade() throws UpgradeException {
        try (Connection connection = DataAccess.getConnection();){
            if (this._getBuildNumber(connection, this.getNewBundleSymbolicName()) == null) {
                super.upgrade();
            }
        }
        catch (SQLException sqlException) {
            throw new UpgradeException((Throwable)sqlException);
        }
    }

    protected void doUpgrade() throws Exception {
        String buildNumber = this._getBuildNumber(this.connection, this.getOldBundleSymbolicName());
        if (buildNumber != null) {
            this._updateRelease(this._toSchemaVersion(buildNumber));
        } else if (this._hasServiceComponent()) {
            this._createRelease();
        }
    }

    protected String getNamespace() {
        return "";
    }

    protected abstract String getNewBundleSymbolicName();

    protected abstract String getOldBundleSymbolicName();

    private void _createRelease() throws Exception {
        ReleaseDAO releaseDAO = new ReleaseDAO();
        releaseDAO.addRelease(this.connection, this.getNewBundleSymbolicName());
    }

    private String _getBuildNumber(Connection connection, String servletContextName) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select buildNumber from Release_ where servletContextName = ?");){
            preparedStatement.setString(1, servletContextName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    String string = resultSet.getString("buildNumber");
                    return string;
                }
            }
        }
        return null;
    }

    private boolean _hasServiceComponent() throws Exception {
        if (Validator.isNull((String)this.getNamespace())) {
            return false;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select serviceComponentId from ServiceComponent where buildNamespace = ?");){
            preparedStatement.setString(1, this.getNamespace());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private String _toSchemaVersion(String buildNumber) {
        StringBuilder sb = new StringBuilder(2 * buildNumber.length());
        for (int i = 0; i < buildNumber.length(); ++i) {
            sb.append(buildNumber.charAt(i));
            sb.append('.');
        }
        if (buildNumber.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private void _updateRelease(String schemaVersion) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update Release_ set servletContextName = ?, schemaVersion = ? where servletContextName = ?");){
            preparedStatement.setString(1, this.getNewBundleSymbolicName());
            preparedStatement.setString(2, schemaVersion);
            preparedStatement.setString(3, this.getOldBundleSymbolicName());
            preparedStatement.execute();
        }
    }
}

