/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.graph;

import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.upgrade.internal.graph.UpgradeProcessEdge;
import com.liferay.portal.upgrade.internal.graph.UpgradeProcessEdgeFactory;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;

public class ReleaseGraphManager {
    private final DirectedGraph<String, UpgradeProcessEdge> _directedGraph;

    public ReleaseGraphManager(List<UpgradeInfo> upgradeInfos) {
        this._directedGraph = new DefaultDirectedGraph((EdgeFactory)new UpgradeProcessEdgeFactory(upgradeInfos));
        for (UpgradeInfo upgradeInfo : upgradeInfos) {
            this._directedGraph.addVertex((Object)upgradeInfo.getFromSchemaVersionString());
            this._directedGraph.addVertex((Object)upgradeInfo.getToSchemaVersionString());
            this._directedGraph.addEdge((Object)upgradeInfo.getFromSchemaVersionString(), (Object)upgradeInfo.getToSchemaVersionString(), (Object)new UpgradeProcessEdge(upgradeInfo));
        }
    }

    public List<UpgradeInfo> getUpgradeInfos(String fromVersionString, String toVersionString) {
        if (!this._directedGraph.containsVertex((Object)fromVersionString)) {
            return Collections.emptyList();
        }
        if (!this._directedGraph.containsVertex((Object)toVersionString)) {
            return Collections.emptyList();
        }
        DijkstraShortestPath dijkstraShortestPath = new DijkstraShortestPath(this._directedGraph, (Object)fromVersionString, (Object)toVersionString);
        List upgradeProcessEdges = dijkstraShortestPath.getPathEdgeList();
        if (upgradeProcessEdges == null) {
            return Collections.emptyList();
        }
        return ListUtil.toList((List)upgradeProcessEdges, (Function)new Function<UpgradeProcessEdge, UpgradeInfo>(){

            public UpgradeInfo apply(UpgradeProcessEdge upgradeProcessEdge) {
                return upgradeProcessEdge.getUpgradeInfo();
            }
        });
    }

    public List<List<UpgradeInfo>> getUpgradeInfosList(String fromVersionString) {
        List<String> endVertices = this.getEndVertices();
        endVertices.remove(fromVersionString);
        ArrayList<List<UpgradeInfo>> upgradeInfosList = new ArrayList<List<UpgradeInfo>>();
        for (String endVertex : endVertices) {
            List<UpgradeInfo> upgradeInfos = this.getUpgradeInfos(fromVersionString, endVertex);
            if (upgradeInfos.isEmpty()) continue;
            upgradeInfosList.add(upgradeInfos);
        }
        return upgradeInfosList;
    }

    protected List<String> getEndVertices() {
        ArrayList<String> endVertices = new ArrayList<String>();
        Set vertices = this._directedGraph.vertexSet();
        for (String vertex : vertices) {
            Set upgradeProcessEdges = this._directedGraph.outgoingEdgesOf((Object)vertex);
            if (!upgradeProcessEdges.isEmpty()) continue;
            endVertices.add(vertex);
        }
        return endVertices;
    }
}

