/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.registry;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true)
public class UpgradeStepRegistratorTracker {
    @Reference(target="(module.service.lifecycle=database.initialized)")
    protected ModuleServiceLifecycle moduleServiceLifecycle;
    private static final Log _log = LogFactoryUtil.getLog(UpgradeStepRegistratorTracker.class);
    private BundleContext _bundleContext;
    private ServiceTracker<UpgradeStepRegistrator, Collection<ServiceRegistration<UpgradeStep>>> _serviceTracker;

    public static List<ServiceRegistration<UpgradeStep>> register(BundleContext bundleContext, String bundleSymbolicName, String fromSchemaVersionString, String toSchemaVersionString, Dictionary<String, Object> properties, UpgradeStep ... upgradeSteps) {
        ArrayList<ServiceRegistration<UpgradeStep>> serviceRegistrations = new ArrayList<ServiceRegistration<UpgradeStep>>();
        List<UpgradeInfo> upgradeInfos = UpgradeStepRegistratorTracker.createUpgradeInfos(fromSchemaVersionString, toSchemaVersionString, GetterUtil.getInteger((Object)properties.get("build.number")), upgradeSteps);
        for (UpgradeInfo upgradeInfo : upgradeInfos) {
            properties.put("build.number", upgradeInfo.getBuildNumber());
            properties.put("upgrade.bundle.symbolic.name", bundleSymbolicName);
            properties.put("upgrade.db.type", "any");
            properties.put("upgrade.from.schema.version", upgradeInfo.getFromSchemaVersionString());
            properties.put("upgrade.to.schema.version", upgradeInfo.getToSchemaVersionString());
            ServiceRegistration serviceRegistration = bundleContext.registerService(UpgradeStep.class, (Object)upgradeInfo.getUpgradeStep(), properties);
            serviceRegistrations.add((ServiceRegistration<UpgradeStep>)serviceRegistration);
        }
        return serviceRegistrations;
    }

    protected static List<UpgradeInfo> createUpgradeInfos(String fromSchemaVersionString, String toSchemaVersionString, int buildNumber, UpgradeStep ... upgradeSteps) {
        if (ArrayUtil.isEmpty((Object[])upgradeSteps)) {
            return Collections.emptyList();
        }
        ArrayList<UpgradeInfo> upgradeInfos = new ArrayList<UpgradeInfo>();
        String upgradeInfoFromSchemaVersionString = fromSchemaVersionString;
        for (int i = 0; i < upgradeSteps.length - 1; ++i) {
            UpgradeStep upgradeStep = upgradeSteps[i];
            String upgradeInfoToSchemaVersionString = toSchemaVersionString + "-step" + (i - upgradeSteps.length + 1);
            UpgradeInfo upgradeInfo = new UpgradeInfo(upgradeInfoFromSchemaVersionString, upgradeInfoToSchemaVersionString, buildNumber, upgradeStep);
            upgradeInfos.add(upgradeInfo);
            upgradeInfoFromSchemaVersionString = upgradeInfoToSchemaVersionString;
        }
        UpgradeInfo upgradeInfo = new UpgradeInfo(upgradeInfoFromSchemaVersionString, toSchemaVersionString, buildNumber, upgradeSteps[upgradeSteps.length - 1]);
        upgradeInfos.add(upgradeInfo);
        return upgradeInfos;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, UpgradeStepRegistrator.class, (ServiceTrackerCustomizer)new UpgradeStepRegistratorServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class UpgradeStepRegistry
    implements UpgradeStepRegistrator.Registry {
        private final Collection<ServiceRegistration<UpgradeStep>> _serviceRegistrations;
        private final UpgradeStepRegistrator _upgradeStepRegistrator;

        public void register(String bundleSymbolicName, String fromSchemaVersionString, String toSchemaVersionString, UpgradeStep ... upgradeSteps) {
            int buildNumber;
            block3: {
                buildNumber = 0;
                try {
                    if (ArrayUtil.isNotEmpty((Object[])upgradeSteps)) {
                        Class<?> clazz = this._upgradeStepRegistrator.getClass();
                        Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)clazz.getClassLoader(), (String)"service");
                        Properties properties = configuration.getProperties();
                        buildNumber = GetterUtil.getInteger((String)properties.getProperty("build.number"));
                    }
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)("Unable to read service.properties for " + bundleSymbolicName));
                }
            }
            HashMapDictionary properties = new HashMapDictionary();
            properties.put("build.number", buildNumber);
            this._serviceRegistrations.addAll(UpgradeStepRegistratorTracker.register(UpgradeStepRegistratorTracker.this._bundleContext, bundleSymbolicName, fromSchemaVersionString, toSchemaVersionString, (Dictionary<String, Object>)properties, upgradeSteps));
        }

        private UpgradeStepRegistry(UpgradeStepRegistrator upgradeStepRegistrator, Collection<ServiceRegistration<UpgradeStep>> serviceRegistrations) {
            this._upgradeStepRegistrator = upgradeStepRegistrator;
            this._serviceRegistrations = serviceRegistrations;
        }
    }

    private class UpgradeStepRegistratorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UpgradeStepRegistrator, Collection<ServiceRegistration<UpgradeStep>>> {
        private UpgradeStepRegistratorServiceTrackerCustomizer() {
        }

        public Collection<ServiceRegistration<UpgradeStep>> addingService(ServiceReference<UpgradeStepRegistrator> serviceReference) {
            UpgradeStepRegistrator upgradeStepRegistrator = (UpgradeStepRegistrator)UpgradeStepRegistratorTracker.this._bundleContext.getService(serviceReference);
            if (upgradeStepRegistrator == null) {
                return null;
            }
            ArrayList<ServiceRegistration<UpgradeStep>> serviceRegistrations = new ArrayList<ServiceRegistration<UpgradeStep>>();
            upgradeStepRegistrator.register((UpgradeStepRegistrator.Registry)new UpgradeStepRegistry(upgradeStepRegistrator, serviceRegistrations));
            return serviceRegistrations;
        }

        public void modifiedService(ServiceReference<UpgradeStepRegistrator> serviceReference, Collection<ServiceRegistration<UpgradeStep>> serviceRegistrations) {
            this.removedService(serviceReference, serviceRegistrations);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<UpgradeStepRegistrator> serviceReference, Collection<ServiceRegistration<UpgradeStep>> serviceRegistrations) {
            for (ServiceRegistration<UpgradeStep> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
    }
}

