/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release.osgi.commands;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBContext;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.output.stream.container.OutputStreamContainer;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactory;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactoryTracker;
import com.liferay.portal.upgrade.internal.configuration.ReleaseManagerConfiguration;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.release.ReleasePublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.upgrade.internal.configuration.ReleaseManagerConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"osgi.command.function=check", "osgi.command.function=execute", "osgi.command.function=executeAll", "osgi.command.function=list", "osgi.command.scope=upgrade"}, service={ReleaseManagerOSGiCommands.class})
public class ReleaseManagerOSGiCommands {
    private static Logger _logger;
    private OutputStreamContainerFactoryTracker _outputStreamContainerFactoryTracker;
    private ReleaseLocalService _releaseLocalService;
    private ReleaseManagerConfiguration _releaseManagerConfiguration;
    private ReleasePublisher _releasePublisher;
    private ServiceTrackerMap<String, List<UpgradeInfo>> _serviceTrackerMap;

    @Descriptor(value="List pending or running upgrades")
    public void check() {
        Set bundleSymbolicNames = this._serviceTrackerMap.keySet();
        for (String bundleSymbolicName : bundleSymbolicNames) {
            String schemaVersionString = this.getSchemaVersionString(bundleSymbolicName);
            ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager((List)this._serviceTrackerMap.getService((Object)bundleSymbolicName));
            List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(schemaVersionString);
            int size = upgradeInfosList.size();
            if (size > 1) {
                System.out.println(StringBundler.concat((String[])new String[]{"There are ", String.valueOf(size), " possible end nodes for ", schemaVersionString}));
            }
            if (size == 0) continue;
            StringBundler sb = new StringBundler(6);
            sb.append("There is an upgrade process available for ");
            sb.append(bundleSymbolicName);
            sb.append(" from ");
            sb.append(schemaVersionString);
            sb.append(" to ");
            List<UpgradeInfo> upgradeInfos = upgradeInfosList.get(0);
            UpgradeInfo lastUpgradeInfo = upgradeInfos.get(upgradeInfos.size() - 1);
            sb.append(lastUpgradeInfo.getToSchemaVersionString());
            System.out.println(sb.toString());
        }
    }

    @Descriptor(value="Execute upgrade for a specific module")
    public void execute(String bundleSymbolicName) {
        if (this._serviceTrackerMap.getService((Object)bundleSymbolicName) == null) {
            System.out.println("No upgrade processes registered for " + bundleSymbolicName);
            return;
        }
        try {
            this.doExecute(bundleSymbolicName, this._serviceTrackerMap);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    @Descriptor(value="Execute upgrade for a specific module and final version")
    public void execute(String bundleSymbolicName, String toVersionString) {
        String schemaVersionString = this.getSchemaVersionString(bundleSymbolicName);
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager((List)this._serviceTrackerMap.getService((Object)bundleSymbolicName));
        this.executeUpgradeInfos(bundleSymbolicName, releaseGraphManager.getUpgradeInfos(schemaVersionString, toVersionString));
    }

    @Descriptor(value="Execute all pending upgrades")
    public void executeAll() {
        HashSet<String> upgradeThrewExceptionBundleSymbolicNames = new HashSet<String>();
        this.executeAll(upgradeThrewExceptionBundleSymbolicNames);
        if (upgradeThrewExceptionBundleSymbolicNames.isEmpty()) {
            System.out.println("All modules were successfully upgraded");
            return;
        }
        StringBundler sb = new StringBundler(upgradeThrewExceptionBundleSymbolicNames.size() * 3 + 3);
        sb.append("\nThe following modules had errors while upgrading:\n");
        for (String upgradeThrewExceptionBundleSymbolicName : upgradeThrewExceptionBundleSymbolicNames) {
            sb.append("\t");
            sb.append(upgradeThrewExceptionBundleSymbolicName);
            sb.append("\n");
        }
        sb.append("Use the command upgrade:list <module name> to get more ");
        sb.append("details about the status of a specific upgrade.");
        System.out.println(sb.toString());
    }

    @Descriptor(value="List registered upgrade processes for all modules")
    public void list() {
        for (String bundleSymbolicName : this._serviceTrackerMap.keySet()) {
            this.list(bundleSymbolicName);
        }
    }

    @Descriptor(value="List registered upgrade processes for a specific module")
    public void list(String bundleSymbolicName) {
        List upgradeProcesses = (List)this._serviceTrackerMap.getService((Object)bundleSymbolicName);
        System.out.println(StringBundler.concat((String[])new String[]{"Registered upgrade processes for ", bundleSymbolicName, " ", this.getSchemaVersionString(bundleSymbolicName)}));
        for (UpgradeInfo upgradeProcess : upgradeProcesses) {
            System.out.println("\t" + upgradeProcess);
        }
    }

    @Reference(unbind="-")
    public void setOutputStreamTracker(OutputStreamContainerFactoryTracker outputStreamContainerFactoryTracker) {
        this._outputStreamContainerFactoryTracker = outputStreamContainerFactoryTracker;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        _logger = new Logger(bundleContext);
        DB db = DBManagerUtil.getDB();
        UpgradeInfoServiceTrackerMapListener serviceTrackerMapListener = null;
        this._releaseManagerConfiguration = (ReleaseManagerConfiguration)ConfigurableUtil.createConfigurable(ReleaseManagerConfiguration.class, properties);
        if (this._releaseManagerConfiguration.autoUpgrade()) {
            serviceTrackerMapListener = new UpgradeInfoServiceTrackerMapListener();
        }
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, UpgradeStep.class, (String)StringBundler.concat((String[])new String[]{"(&(upgrade.bundle.symbolic.name=*)(|(upgrade.db.type=any)", "(upgrade.db.type=", String.valueOf(db.getDBType()), ")))"}), (ServiceReferenceMapper)new PropertyServiceReferenceMapper("upgrade.bundle.symbolic.name"), (ServiceTrackerCustomizer)new UpgradeServiceTrackerCustomizer(bundleContext), Collections.reverseOrder(new PropertyServiceReferenceComparator("upgrade.from.schema.version")), (ServiceTrackerMapListener)serviceTrackerMapListener);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected void doExecute(String bundleSymbolicName, ServiceTrackerMap<String, List<UpgradeInfo>> serviceTrackerMap) {
        List<List<UpgradeInfo>> upgradeInfosList = this.getUpgradeInfosList(bundleSymbolicName, serviceTrackerMap);
        int size = upgradeInfosList.size();
        if (size > 1) {
            throw new IllegalStateException(StringBundler.concat((String[])new String[]{"There are ", String.valueOf(size), " possible end nodes for ", this.getSchemaVersionString(bundleSymbolicName)}));
        }
        if (size == 0) {
            return;
        }
        this.executeUpgradeInfos(bundleSymbolicName, upgradeInfosList.get(0));
    }

    protected void executeAll(Set<String> upgradeThrewExceptionBundleSymbolicNames) {
        Set<String> upgradableBundleSymbolicNames = this.getUpgradableBundleSymbolicNames();
        upgradableBundleSymbolicNames.removeAll(upgradeThrewExceptionBundleSymbolicNames);
        if (upgradableBundleSymbolicNames.isEmpty()) {
            return;
        }
        for (String upgradableBundleSymbolicName : upgradableBundleSymbolicNames) {
            try {
                this.doExecute(upgradableBundleSymbolicName, this._serviceTrackerMap);
            }
            catch (Throwable t) {
                System.out.println(StringBundler.concat((String[])new String[]{"\nFailed upgrade process for module ", upgradableBundleSymbolicName, ":"}));
                t.printStackTrace(System.out);
                upgradeThrewExceptionBundleSymbolicNames.add(upgradableBundleSymbolicName);
            }
        }
        this.executeAll(upgradeThrewExceptionBundleSymbolicNames);
    }

    protected void executeUpgradeInfos(String bundleSymbolicName, List<UpgradeInfo> upgradeInfos) {
        OutputStreamContainerFactory outputStreamContainerFactory = this._outputStreamContainerFactoryTracker.getOutputStreamContainerFactory();
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create("upgrade-" + bundleSymbolicName);
        OutputStream outputStream = outputStreamContainer.getOutputStream();
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null) {
            this._releasePublisher.publishInProgress(release);
        }
        this._outputStreamContainerFactoryTracker.runWithSwappedLog((Runnable)new UpgradeInfosRunnable(bundleSymbolicName, upgradeInfos, outputStream), outputStreamContainer.getDescription(), outputStream);
        try {
            outputStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null) {
            this._releasePublisher.publish(release);
        }
    }

    protected String getSchemaVersionString(String bundleSymbolicName) {
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release == null || Validator.isNull((String)release.getSchemaVersion())) {
            return "0.0.0";
        }
        return release.getSchemaVersion();
    }

    protected Set<String> getUpgradableBundleSymbolicNames() {
        HashSet<String> upgradableBundleSymbolicNames = new HashSet<String>();
        for (String bundleSymbolicName : this._serviceTrackerMap.keySet()) {
            if (!this.isUpgradable(bundleSymbolicName)) continue;
            upgradableBundleSymbolicNames.add(bundleSymbolicName);
        }
        return upgradableBundleSymbolicNames;
    }

    protected List<List<UpgradeInfo>> getUpgradeInfosList(String bundleSymbolicName, ServiceTrackerMap<String, List<UpgradeInfo>> serviceTrackerMap) {
        String schemaVersionString = this.getSchemaVersionString(bundleSymbolicName);
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager((List)serviceTrackerMap.getService((Object)bundleSymbolicName));
        return releaseGraphManager.getUpgradeInfosList(schemaVersionString);
    }

    protected boolean isUpgradable(String bundleSymbolicName) {
        List<List<UpgradeInfo>> upgradeInfosList = this.getUpgradeInfosList(bundleSymbolicName, this._serviceTrackerMap);
        return upgradeInfosList.size() == 1;
    }

    @Reference(unbind="-")
    protected void setReleaseLocalService(ReleaseLocalService releaseLocalService) {
        this._releaseLocalService = releaseLocalService;
    }

    @Reference(unbind="-")
    protected void setReleasePublisher(ReleasePublisher releasePublisher) {
        this._releasePublisher = releasePublisher;
    }

    private class UpgradeInfosRunnable
    implements Runnable {
        private static final int _STATE_IN_PROGRESS = -1;
        private final String _bundleSymbolicName;
        private final OutputStream _outputStream;
        private final List<UpgradeInfo> _upgradeInfos;

        public UpgradeInfosRunnable(String bundleSymbolicName, List<UpgradeInfo> upgradeInfos, OutputStream outputStream) {
            this._bundleSymbolicName = bundleSymbolicName;
            this._upgradeInfos = upgradeInfos;
            this._outputStream = outputStream;
        }

        @Override
        public void run() {
            int buildNumber = 0;
            int state = 0;
            for (UpgradeInfo upgradeInfo : this._upgradeInfos) {
                UpgradeStep upgradeStep = upgradeInfo.getUpgradeStep();
                try {
                    this._updateReleaseState(-1);
                    upgradeStep.upgrade(new DBProcessContext(){

                        public DBContext getDBContext() {
                            return new DBContext();
                        }

                        public OutputStream getOutputStream() {
                            return UpgradeInfosRunnable.this._outputStream;
                        }
                    });
                    ReleaseManagerOSGiCommands.this._releaseLocalService.updateRelease(this._bundleSymbolicName, upgradeInfo.getToSchemaVersionString(), upgradeInfo.getFromSchemaVersionString());
                    buildNumber = upgradeInfo.getBuildNumber();
                }
                catch (Exception e) {
                    state = 1;
                    throw new RuntimeException(e);
                }
                finally {
                    Release release = ReleaseManagerOSGiCommands.this._releaseLocalService.fetchRelease(this._bundleSymbolicName);
                    if (release == null || buildNumber <= 0 && state != true) continue;
                    release.setBuildNumber(buildNumber);
                    release.setState(state);
                    ReleaseManagerOSGiCommands.this._releaseLocalService.updateRelease(release);
                }
            }
            this._updateReleaseState(0);
            CacheRegistryUtil.clear();
        }

        private void _updateReleaseState(int state) {
            Release release = ReleaseManagerOSGiCommands.this._releaseLocalService.fetchRelease(this._bundleSymbolicName);
            if (release != null) {
                release.setState(state);
                ReleaseManagerOSGiCommands.this._releaseLocalService.updateRelease(release);
            }
        }
    }

    private class UpgradeInfoServiceTrackerMapListener
    implements ServiceTrackerMapListener<String, UpgradeInfo, List<UpgradeInfo>> {
        private UpgradeInfoServiceTrackerMapListener() {
        }

        public void keyEmitted(ServiceTrackerMap<String, List<UpgradeInfo>> serviceTrackerMap, String key, UpgradeInfo upgradeInfo, List<UpgradeInfo> upgradeInfos) {
            ReleaseManagerOSGiCommands.this.doExecute(key, serviceTrackerMap);
        }

        public void keyRemoved(ServiceTrackerMap<String, List<UpgradeInfo>> serviceTrackerMap, String key, UpgradeInfo upgradeInfo, List<UpgradeInfo> upgradeInfos) {
        }
    }

    private static class UpgradeServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UpgradeStep, UpgradeInfo> {
        private final BundleContext _bundleContext;

        public UpgradeServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public UpgradeInfo addingService(ServiceReference<UpgradeStep> serviceReference) {
            String fromSchemaVersionString = (String)serviceReference.getProperty("upgrade.from.schema.version");
            String toSchemaVersionString = (String)serviceReference.getProperty("upgrade.to.schema.version");
            UpgradeStep upgradeStep = (UpgradeStep)this._bundleContext.getService(serviceReference);
            if (upgradeStep == null) {
                _logger.log(2, "Skipping service " + serviceReference + " because it does not implement UpgradeStep");
                return null;
            }
            int buildNumber = 0;
            try {
                Class<?> clazz = upgradeStep.getClass();
                Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)clazz.getClassLoader(), (String)"service");
                Properties properties = configuration.getProperties();
                buildNumber = GetterUtil.getInteger((String)properties.getProperty("build.number"));
            }
            catch (Exception e) {
                _logger.log(4, "Unable to read service.properties for " + serviceReference);
            }
            return new UpgradeInfo(fromSchemaVersionString, toSchemaVersionString, buildNumber, upgradeStep);
        }

        public void modifiedService(ServiceReference<UpgradeStep> serviceReference, UpgradeInfo upgradeInfo) {
        }

        public void removedService(ServiceReference<UpgradeStep> serviceReference, UpgradeInfo upgradeInfo) {
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

