/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.index.updater;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class IndexUpdaterUtil {
    private static final Log _log = LogFactoryUtil.getLog(IndexUpdaterUtil.class);

    public static Bundle getBundle(BundleContext bundleContext, String bundleSymbolicName) {
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!bundleSymbolicName.equals(bundle.getSymbolicName())) continue;
            return bundle;
        }
        throw new IllegalArgumentException("Module with symbolic name " + bundleSymbolicName + " does not exist");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSQLTemplateString(Bundle bundle, String templateName) {
        URL resource = bundle.getResource("/META-INF/sql/" + templateName);
        if (resource == null) {
            return null;
        }
        try (InputStream inputStream = resource.openStream();){
            String string = StringUtil.read((InputStream)inputStream);
            return string;
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to read SQL template " + templateName), (Throwable)ioe);
            return null;
        }
    }

    public static boolean isLiferayServiceBundle(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        return GetterUtil.getBoolean((String)((String)headers.get("Liferay-Service")));
    }

    public static void updateIndexes(Bundle bundle) throws Exception {
        String indexesSQL = IndexUpdaterUtil.getSQLTemplateString(bundle, "indexes.sql");
        String tablesSQL = IndexUpdaterUtil.getSQLTemplateString(bundle, "tables.sql");
        if (indexesSQL == null || tablesSQL == null) {
            return;
        }
        DB db = DBManagerUtil.getDB();
        String loggingTimerName = "Updating database indexes for " + bundle.getSymbolicName();
        try (Connection connection = DataAccess.getConnection();
             LoggingTimer loggingTimer = new LoggingTimer(loggingTimerName);){
            db.updateIndexes(connection, tablesSQL, indexesSQL, true);
        }
    }
}

