/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release;

import aQute.bnd.version.Version;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ReleasePublisher.class})
public final class ReleasePublisher {
    private static final int _STATE_IN_PROGRESS = -1;
    private BundleContext _bundleContext;
    private ReleaseLocalService _releaseLocalService;
    private final Map<String, ServiceRegistration<Release>> _serviceConfiguratorRegistrations = new HashMap<String, ServiceRegistration<Release>>();

    public void publish(Release release) {
        ServiceRegistration<Release> oldServiceRegistration = this._serviceConfiguratorRegistrations.get(release.getServletContextName());
        if (oldServiceRegistration != null) {
            oldServiceRegistration.unregister();
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("release.bundle.symbolic.name", release.getBundleSymbolicName());
        ((Dictionary)properties).put("release.state", release.getState());
        if (Version.isVersion((String)release.getSchemaVersion())) {
            ((Dictionary)properties).put("release.schema.version", new Version(release.getSchemaVersion()));
        }
        ServiceRegistration newServiceRegistration = this._bundleContext.registerService(Release.class, (Object)release, properties);
        this._serviceConfiguratorRegistrations.put(release.getServletContextName(), (ServiceRegistration<Release>)newServiceRegistration);
    }

    public void publishInProgress(Release release) {
        release.setState(-1);
        this.publish(release);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        List releases = this._releaseLocalService.getReleases(-1, -1);
        for (Release release : releases) {
            this.publish(release);
        }
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<Release> serviceRegistration : this._serviceConfiguratorRegistrations.values()) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setReleaseLocalService(ReleaseLocalService releaseLocalService) {
        this._releaseLocalService = releaseLocalService;
    }
}

