/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release.osgi.commands;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.internal.configuration.ReleaseManagerConfiguration;
import com.liferay.portal.upgrade.internal.executor.UpgradeExecutor;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.registry.UpgradeStepRegistratorThreadLocal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.upgrade.internal.configuration.ReleaseManagerConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"osgi.command.function=check", "osgi.command.function=execute", "osgi.command.function=executeAll", "osgi.command.function=list", "osgi.command.scope=upgrade"}, service={ReleaseManagerOSGiCommands.class})
public class ReleaseManagerOSGiCommands {
    private static Logger _logger;
    private boolean _activated;
    private ReleaseLocalService _releaseLocalService;
    private ReleaseManagerConfiguration _releaseManagerConfiguration;
    private ServiceTrackerMap<String, List<UpgradeInfo>> _serviceTrackerMap;
    @Reference
    private UpgradeExecutor _upgradeExecutor;

    @Descriptor(value="List pending or running upgrades")
    public void check() {
        Set bundleSymbolicNames = this._serviceTrackerMap.keySet();
        for (String bundleSymbolicName : bundleSymbolicNames) {
            String schemaVersionString = this.getSchemaVersionString(bundleSymbolicName);
            ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager((List)this._serviceTrackerMap.getService((Object)bundleSymbolicName));
            List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(schemaVersionString);
            int size = upgradeInfosList.size();
            if (size > 1) {
                System.out.println(StringBundler.concat((Object[])new Object[]{"There are ", size, " possible end nodes for ", schemaVersionString}));
            }
            if (size == 0) continue;
            StringBundler sb = new StringBundler(6);
            sb.append("There is an upgrade process available for ");
            sb.append(bundleSymbolicName);
            sb.append(" from ");
            sb.append(schemaVersionString);
            sb.append(" to ");
            List<UpgradeInfo> upgradeInfos = upgradeInfosList.get(0);
            UpgradeInfo lastUpgradeInfo = upgradeInfos.get(upgradeInfos.size() - 1);
            sb.append(lastUpgradeInfo.getToSchemaVersionString());
            System.out.println(sb.toString());
        }
    }

    @Descriptor(value="Execute upgrade for a specific module")
    public void execute(String bundleSymbolicName) {
        if (this._serviceTrackerMap.getService((Object)bundleSymbolicName) == null) {
            System.out.println("No upgrade processes registered for " + bundleSymbolicName);
            return;
        }
        try {
            List upgradeInfos = (List)this._serviceTrackerMap.getService((Object)bundleSymbolicName);
            this._upgradeExecutor.execute(bundleSymbolicName, upgradeInfos);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    @Descriptor(value="Execute upgrade for a specific module and final version")
    public void execute(String bundleSymbolicName, String toVersionString) {
        String schemaVersionString = this.getSchemaVersionString(bundleSymbolicName);
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager((List)this._serviceTrackerMap.getService((Object)bundleSymbolicName));
        this._upgradeExecutor.executeUpgradeInfos(bundleSymbolicName, releaseGraphManager.getUpgradeInfos(schemaVersionString, toVersionString));
    }

    @Descriptor(value="Execute all pending upgrades")
    public void executeAll() {
        HashSet<String> upgradeThrewExceptionBundleSymbolicNames = new HashSet<String>();
        this.executeAll(upgradeThrewExceptionBundleSymbolicNames);
        if (upgradeThrewExceptionBundleSymbolicNames.isEmpty()) {
            System.out.println("All modules were successfully upgraded");
            return;
        }
        StringBundler sb = new StringBundler(upgradeThrewExceptionBundleSymbolicNames.size() * 3 + 3);
        sb.append("\nThe following modules had errors while upgrading:\n");
        for (String upgradeThrewExceptionBundleSymbolicName : upgradeThrewExceptionBundleSymbolicNames) {
            sb.append("\t");
            sb.append(upgradeThrewExceptionBundleSymbolicName);
            sb.append("\n");
        }
        sb.append("Use the command upgrade:list <module name> to get more ");
        sb.append("details about the status of a specific upgrade.");
        System.out.println(sb.toString());
    }

    @Descriptor(value="List registered upgrade processes for all modules")
    public void list() {
        for (String bundleSymbolicName : this._serviceTrackerMap.keySet()) {
            this.list(bundleSymbolicName);
        }
    }

    @Descriptor(value="List registered upgrade processes for a specific module")
    public void list(String bundleSymbolicName) {
        List upgradeProcesses = (List)this._serviceTrackerMap.getService((Object)bundleSymbolicName);
        System.out.println(StringBundler.concat((String[])new String[]{"Registered upgrade processes for ", bundleSymbolicName, " ", this.getSchemaVersionString(bundleSymbolicName)}));
        for (UpgradeInfo upgradeProcess : upgradeProcesses) {
            System.out.println("\t" + upgradeProcess);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        _logger = new Logger(bundleContext);
        DB db = DBManagerUtil.getDB();
        UpgradeInfoServiceTrackerMapListener serviceTrackerMapListener = null;
        this._releaseManagerConfiguration = (ReleaseManagerConfiguration)ConfigurableUtil.createConfigurable(ReleaseManagerConfiguration.class, properties);
        if (this._releaseManagerConfiguration.autoUpgrade()) {
            serviceTrackerMapListener = new UpgradeInfoServiceTrackerMapListener();
        }
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, UpgradeStep.class, (String)StringBundler.concat((Object[])new Object[]{"(&(upgrade.bundle.symbolic.name=*)(|(upgrade.db.type=any)", "(upgrade.db.type=", db.getDBType(), ")))"}), (ServiceReferenceMapper)new PropertyServiceReferenceMapper("upgrade.bundle.symbolic.name"), (ServiceTrackerCustomizer)new UpgradeServiceTrackerCustomizer(bundleContext), Collections.reverseOrder(new PropertyServiceReferenceComparator("upgrade.from.schema.version")), (ServiceTrackerMapListener)serviceTrackerMapListener);
        if (this._releaseManagerConfiguration.autoUpgrade()) {
            HashSet upgradedBundleSymbolicNames = new HashSet();
            Set bundleSymbolicNames = this._serviceTrackerMap.keySet();
            while (upgradedBundleSymbolicNames.addAll(bundleSymbolicNames)) {
                for (String bundleSymbolicName : bundleSymbolicNames) {
                    List upgradeSteps = (List)this._serviceTrackerMap.getService((Object)bundleSymbolicName);
                    this._upgradeExecutor.execute(bundleSymbolicName, upgradeSteps);
                }
                bundleSymbolicNames = this._serviceTrackerMap.keySet();
            }
        }
        this._activated = true;
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected void executeAll(Set<String> upgradeThrewExceptionBundleSymbolicNames) {
        Set<String> upgradableBundleSymbolicNames = this.getUpgradableBundleSymbolicNames();
        upgradableBundleSymbolicNames.removeAll(upgradeThrewExceptionBundleSymbolicNames);
        if (upgradableBundleSymbolicNames.isEmpty()) {
            return;
        }
        for (String upgradableBundleSymbolicName : upgradableBundleSymbolicNames) {
            try {
                List upgradeInfos = (List)this._serviceTrackerMap.getService((Object)upgradableBundleSymbolicName);
                this._upgradeExecutor.execute(upgradableBundleSymbolicName, upgradeInfos);
            }
            catch (Throwable t) {
                System.out.println(StringBundler.concat((String[])new String[]{"\nFailed upgrade process for module ", upgradableBundleSymbolicName, ":"}));
                t.printStackTrace(System.out);
                upgradeThrewExceptionBundleSymbolicNames.add(upgradableBundleSymbolicName);
            }
        }
        this.executeAll(upgradeThrewExceptionBundleSymbolicNames);
    }

    protected String getSchemaVersionString(String bundleSymbolicName) {
        String schemaVersionString = "0.0.0";
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null && Validator.isNotNull((String)release.getSchemaVersion())) {
            schemaVersionString = release.getSchemaVersion();
        }
        return schemaVersionString;
    }

    protected Set<String> getUpgradableBundleSymbolicNames() {
        HashSet<String> upgradableBundleSymbolicNames = new HashSet<String>();
        for (String bundleSymbolicName : this._serviceTrackerMap.keySet()) {
            if (!this.isUpgradable(bundleSymbolicName)) continue;
            upgradableBundleSymbolicNames.add(bundleSymbolicName);
        }
        return upgradableBundleSymbolicNames;
    }

    protected boolean isUpgradable(String bundleSymbolicName) {
        String schemaVersionString = this.getSchemaVersionString(bundleSymbolicName);
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager((List)this._serviceTrackerMap.getService((Object)bundleSymbolicName));
        List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(schemaVersionString);
        return upgradeInfosList.size() == 1;
    }

    @Reference(unbind="-")
    protected void setReleaseLocalService(ReleaseLocalService releaseLocalService) {
        this._releaseLocalService = releaseLocalService;
    }

    private class UpgradeInfoServiceTrackerMapListener
    implements ServiceTrackerMapListener<String, UpgradeInfo, List<UpgradeInfo>> {
        private UpgradeInfoServiceTrackerMapListener() {
        }

        public void keyEmitted(ServiceTrackerMap<String, List<UpgradeInfo>> serviceTrackerMap, String key, UpgradeInfo upgradeInfo, List<UpgradeInfo> upgradeInfos) {
            if (ReleaseManagerOSGiCommands.this._activated && UpgradeStepRegistratorThreadLocal.isEnabled()) {
                ReleaseManagerOSGiCommands.this._upgradeExecutor.execute(key, upgradeInfos);
            }
        }

        public void keyRemoved(ServiceTrackerMap<String, List<UpgradeInfo>> serviceTrackerMap, String key, UpgradeInfo upgradeInfo, List<UpgradeInfo> upgradeInfos) {
        }
    }

    private static class UpgradeServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UpgradeStep, UpgradeInfo> {
        private final BundleContext _bundleContext;

        public UpgradeServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public UpgradeInfo addingService(ServiceReference<UpgradeStep> serviceReference) {
            String fromSchemaVersionString = (String)serviceReference.getProperty("upgrade.from.schema.version");
            String toSchemaVersionString = (String)serviceReference.getProperty("upgrade.to.schema.version");
            Object buildNumberObject = serviceReference.getProperty("build.number");
            UpgradeStep upgradeStep = (UpgradeStep)this._bundleContext.getService(serviceReference);
            if (upgradeStep == null) {
                _logger.log(2, "Skipping service " + serviceReference + " because it does not implement UpgradeStep");
                return null;
            }
            int buildNumber = 0;
            if (buildNumberObject == null) {
                try {
                    Class<?> clazz = upgradeStep.getClass();
                    Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)clazz.getClassLoader(), (String)"service");
                    Properties properties = configuration.getProperties();
                    buildNumber = GetterUtil.getInteger((String)properties.getProperty("build.number"));
                }
                catch (Exception e) {
                    _logger.log(4, "Unable to read service.properties for " + serviceReference);
                }
            } else {
                buildNumber = GetterUtil.getInteger((Object)buildNumberObject);
            }
            return new UpgradeInfo(fromSchemaVersionString, toSchemaVersionString, buildNumber, upgradeStep);
        }

        public void modifiedService(ServiceReference<UpgradeStep> serviceReference, UpgradeInfo upgradeInfo) {
        }

        public void removedService(ServiceReference<UpgradeStep> serviceReference, UpgradeInfo upgradeInfo) {
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

