/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.registry;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.upgrade.internal.executor.SwappedLogExecutor;
import com.liferay.portal.upgrade.internal.executor.UpgradeExecutor;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.registry.UpgradeStepRegistratorThreadLocal;
import com.liferay.portal.upgrade.internal.registry.UpgradeStepRegistry;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
public class UpgradeStepRegistratorTracker {
    private BundleContext _bundleContext;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    private ServiceTracker<UpgradeStepRegistrator, Collection<ServiceRegistration<UpgradeStep>>> _serviceTracker;
    @Reference
    private SwappedLogExecutor _swappedLogExecutor;
    @Reference
    private UpgradeExecutor _upgradeExecutor;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, UpgradeStepRegistrator.class, (ServiceTrackerCustomizer)new UpgradeStepRegistratorServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class UpgradeStepRegistratorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UpgradeStepRegistrator, Collection<ServiceRegistration<UpgradeStep>>> {
        private final Log _log = LogFactoryUtil.getLog(UpgradeStepRegistratorTracker.class);

        private UpgradeStepRegistratorServiceTrackerCustomizer() {
        }

        public Collection<ServiceRegistration<UpgradeStep>> addingService(ServiceReference<UpgradeStepRegistrator> serviceReference) {
            UpgradeStepRegistrator upgradeStepRegistrator = (UpgradeStepRegistrator)UpgradeStepRegistratorTracker.this._bundleContext.getService(serviceReference);
            if (upgradeStepRegistrator == null) {
                return null;
            }
            Class<?> clazz = upgradeStepRegistrator.getClass();
            Bundle bundle = FrameworkUtil.getBundle(clazz);
            String bundleSymbolicName = bundle.getSymbolicName();
            int buildNumber = 0;
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader.getResource("service.properties") != null) {
                Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
                Properties properties = configuration.getProperties();
                buildNumber = GetterUtil.getInteger((String)properties.getProperty("build.number"));
            }
            UpgradeStepRegistry upgradeStepRegistry = new UpgradeStepRegistry(buildNumber);
            upgradeStepRegistrator.register((UpgradeStepRegistrator.Registry)upgradeStepRegistry);
            List<UpgradeInfo> upgradeInfos = upgradeStepRegistry.getUpgradeInfos();
            if (PropsValues.UPGRADE_DATABASE_AUTO_RUN || UpgradeStepRegistratorTracker.this._releaseLocalService.fetchRelease(bundleSymbolicName) == null) {
                try {
                    UpgradeStepRegistratorTracker.this._upgradeExecutor.execute(bundleSymbolicName, upgradeInfos, "dummy");
                }
                catch (Throwable throwable) {
                    UpgradeStepRegistratorTracker.this._swappedLogExecutor.execute(bundleSymbolicName, () -> this._log.error((Object)"Failed upgrade process for module ".concat(bundleSymbolicName), throwable), null);
                }
            }
            ArrayList<ServiceRegistration<UpgradeStep>> serviceRegistrations = new ArrayList<ServiceRegistration<UpgradeStep>>(upgradeInfos.size());
            try (SafeClosable safeClosable = UpgradeStepRegistratorThreadLocal.setEnabled(false);){
                for (UpgradeInfo upgradeInfo : upgradeInfos) {
                    HashMapDictionary properties = new HashMapDictionary();
                    properties.put("build.number", upgradeInfo.getBuildNumber());
                    properties.put("upgrade.bundle.symbolic.name", bundleSymbolicName);
                    properties.put("upgrade.db.type", "any");
                    properties.put("upgrade.from.schema.version", upgradeInfo.getFromSchemaVersionString());
                    properties.put("upgrade.to.schema.version", upgradeInfo.getToSchemaVersionString());
                    ServiceRegistration serviceRegistration = UpgradeStepRegistratorTracker.this._bundleContext.registerService(UpgradeStep.class, (Object)upgradeInfo.getUpgradeStep(), (Dictionary)properties);
                    serviceRegistrations.add((ServiceRegistration<UpgradeStep>)serviceRegistration);
                }
            }
            return serviceRegistrations;
        }

        public void modifiedService(ServiceReference<UpgradeStepRegistrator> serviceReference, Collection<ServiceRegistration<UpgradeStep>> serviceRegistrations) {
        }

        public void removedService(ServiceReference<UpgradeStepRegistrator> serviceReference, Collection<ServiceRegistration<UpgradeStep>> serviceRegistrations) {
            for (ServiceRegistration<UpgradeStep> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
    }
}

