/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.ReleaseManager;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.upgrade.internal.executor.UpgradeExecutor;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.registry.UpgradeStepRegistratorThreadLocal;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={ReleaseManager.class, ReleaseManagerImpl.class})
public class ReleaseManagerImpl
implements ReleaseManager {
    private static final Log _log = LogFactoryUtil.getLog(ReleaseManagerImpl.class);
    private boolean _activated;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    private ServiceTrackerMap<String, List<UpgradeInfo>> _serviceTrackerMap;
    @Reference
    private UpgradeExecutor _upgradeExecutor;

    public Set<String> getBundleSymbolicNames() {
        return this._serviceTrackerMap.keySet();
    }

    public String getSchemaVersionString(String bundleSymbolicName) {
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null && Validator.isNotNull((String)release.getSchemaVersion())) {
            return release.getSchemaVersion();
        }
        return "0.0.0";
    }

    public String getStatusMessage(boolean onlyRequiredUpgrades) {
        String where;
        String message;
        block19: {
            message = "%s upgrades in %s are pending. Run the upgrade process or type upgrade:checkAll in the Gogo shell to get more information.";
            if (onlyRequiredUpgrades) {
                if (this._isPendingRequiredModuleUpgrades()) {
                    return String.format(message, "Required", "modules");
                }
                return "";
            }
            where = "";
            try (Connection connection = DataAccess.getConnection();){
                if (!PortalUpgradeProcess.isInLatestSchemaVersion((Connection)connection)) {
                    where = "portal";
                }
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block19;
                _log.warn((Object)"Unable to get pending upgrade information for the portal");
            }
        }
        if (this._isPendingModuleUpgrades()) {
            where = Validator.isNotNull((String)where) ? "and " + where : "modules";
        }
        if (Validator.isNotNull((String)where)) {
            return String.format(message, "Optional", where);
        }
        return "";
    }

    public Set<String> getUpgradableBundleSymbolicNames() {
        HashSet<String> upgradableBundleSymbolicNames = new HashSet<String>();
        for (String bundleSymbolicName : this.getBundleSymbolicNames()) {
            if (!this._isUpgradable(bundleSymbolicName)) continue;
            upgradableBundleSymbolicNames.add(bundleSymbolicName);
        }
        return upgradableBundleSymbolicNames;
    }

    public List<UpgradeInfo> getUpgradeInfos(String bundleSymbolicName) {
        return (List)this._serviceTrackerMap.getService((Object)bundleSymbolicName);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        DB db = DBManagerUtil.getDB();
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, UpgradeStep.class, (String)StringBundler.concat((Object[])new Object[]{"(&(upgrade.bundle.symbolic.name=*)(|(upgrade.db.type=any)", "(upgrade.db.type=", db.getDBType(), ")))"}), (ServiceReferenceMapper)new PropertyServiceReferenceMapper("upgrade.bundle.symbolic.name"), (ServiceTrackerCustomizer)new UpgradeServiceTrackerCustomizer(bundleContext), Collections.reverseOrder(new PropertyServiceReferenceComparator("upgrade.from.schema.version")), (ServiceTrackerMapListener)new UpgradeInfoServiceTrackerMapListener());
        HashSet upgradedBundleSymbolicNames = new HashSet();
        Set bundleSymbolicNames = this._serviceTrackerMap.keySet();
        while (upgradedBundleSymbolicNames.addAll(bundleSymbolicNames)) {
            for (String bundleSymbolicName : bundleSymbolicNames) {
                if (!PropsValues.UPGRADE_DATABASE_AUTO_RUN && this._releaseLocalService.fetchRelease(bundleSymbolicName) != null) continue;
                List upgradeSteps = (List)this._serviceTrackerMap.getService((Object)bundleSymbolicName);
                this._upgradeExecutor.execute(bundleSymbolicName, upgradeSteps, "dummy");
            }
            bundleSymbolicNames = this._serviceTrackerMap.keySet();
        }
        this._activated = true;
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private boolean _isPendingModuleUpgrades() {
        for (String bundleSymbolicName : this.getBundleSymbolicNames()) {
            if (!this._isUpgradable(bundleSymbolicName)) continue;
            return true;
        }
        return false;
    }

    private boolean _isPendingRequiredModuleUpgrades() {
        Set<String> upgradableBundleSymbolicNames = this.getUpgradableBundleSymbolicNames();
        for (String bundleSymbolicName : upgradableBundleSymbolicNames) {
            ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(this.getUpgradeInfos(bundleSymbolicName));
            List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(this.getSchemaVersionString(bundleSymbolicName));
            List<UpgradeInfo> upgradeInfos = upgradeInfosList.get(0);
            for (UpgradeInfo upgradeInfo : upgradeInfos) {
                if (!UpgradeProcessUtil.isRequiredSchemaVersion((Version)Version.parseVersion((String)upgradeInfo.getFromSchemaVersionString()), (Version)Version.parseVersion((String)upgradeInfo.getToSchemaVersionString()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isUpgradable(String bundleSymbolicName) {
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(this.getUpgradeInfos(bundleSymbolicName));
        List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(this.getSchemaVersionString(bundleSymbolicName));
        return upgradeInfosList.size() == 1;
    }

    private class UpgradeInfoServiceTrackerMapListener
    implements ServiceTrackerMapListener<String, UpgradeInfo, List<UpgradeInfo>> {
        private UpgradeInfoServiceTrackerMapListener() {
        }

        public void keyEmitted(ServiceTrackerMap<String, List<UpgradeInfo>> serviceTrackerMap, String key, UpgradeInfo upgradeInfo, List<UpgradeInfo> upgradeInfos) {
            if (ReleaseManagerImpl.this._activated && UpgradeStepRegistratorThreadLocal.isEnabled() && (PropsValues.UPGRADE_DATABASE_AUTO_RUN || ReleaseManagerImpl.this._releaseLocalService.fetchRelease(key) == null)) {
                ReleaseManagerImpl.this._upgradeExecutor.execute(key, upgradeInfos, null);
            }
        }

        public void keyRemoved(ServiceTrackerMap<String, List<UpgradeInfo>> serviceTrackerMap, String key, UpgradeInfo upgradeInfo, List<UpgradeInfo> upgradeInfos) {
        }
    }

    private static class UpgradeServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UpgradeStep, UpgradeInfo> {
        private final BundleContext _bundleContext;

        public UpgradeServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public UpgradeInfo addingService(ServiceReference<UpgradeStep> serviceReference) {
            String fromSchemaVersionString = (String)serviceReference.getProperty("upgrade.from.schema.version");
            String toSchemaVersionString = (String)serviceReference.getProperty("upgrade.to.schema.version");
            Object buildNumberObject = serviceReference.getProperty("build.number");
            UpgradeStep upgradeStep = (UpgradeStep)this._bundleContext.getService(serviceReference);
            if (upgradeStep == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Skipping service " + serviceReference + " because it does not implement UpgradeStep"));
                }
                return null;
            }
            int buildNumber = 0;
            if (buildNumberObject == null) {
                try {
                    Class<?> clazz = upgradeStep.getClass();
                    Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)clazz.getClassLoader(), (String)"service");
                    Properties properties = configuration.getProperties();
                    buildNumber = GetterUtil.getInteger((String)properties.getProperty("build.number"));
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Unable to read service.properties for " + serviceReference));
                    }
                }
            } else {
                buildNumber = GetterUtil.getInteger((Object)buildNumberObject);
            }
            return new UpgradeInfo(fromSchemaVersionString, toSchemaVersionString, buildNumber, upgradeStep);
        }

        public void modifiedService(ServiceReference<UpgradeStep> serviceReference, UpgradeInfo upgradeInfo) {
        }

        public void removedService(ServiceReference<UpgradeStep> serviceReference, UpgradeInfo upgradeInfo) {
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

