/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.executor;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.db.DBContext;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.upgrade.internal.executor.SwappedLogExecutor;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.index.updater.IndexUpdaterUtil;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.release.ReleasePublisher;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UpgradeExecutor.class})
public class UpgradeExecutor {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeExecutor.class);
    private BundleContext _bundleContext;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private ReleasePublisher _releasePublisher;
    @Reference
    private SwappedLogExecutor _swappedLogExecutor;

    public void execute(String bundleSymbolicName, List<UpgradeInfo> upgradeInfos, String outputStreamContainerFactoryName) {
        List<List<UpgradeInfo>> upgradeInfosList;
        int size;
        Bundle bundle = null;
        for (UpgradeInfo upgradeInfo : upgradeInfos) {
            UpgradeStep upgradeStep = upgradeInfo.getUpgradeStep();
            Bundle currentBundle = FrameworkUtil.getBundle(upgradeStep.getClass());
            if (currentBundle == null || !Objects.equals(currentBundle.getSymbolicName(), bundleSymbolicName)) continue;
            bundle = currentBundle;
            break;
        }
        Version requiredVersion = null;
        if (bundle != null) {
            Dictionary headers = bundle.getHeaders("");
            requiredVersion = Version.parseVersion((String)((String)headers.get("Liferay-Require-SchemaVersion")));
        }
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(upgradeInfos);
        String schemaVersionString = "0.0.0";
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null && Validator.isNotNull((String)release.getSchemaVersion())) {
            schemaVersionString = release.getSchemaVersion();
        }
        if ((size = (upgradeInfosList = releaseGraphManager.getUpgradeInfosList(schemaVersionString)).size()) > 1) {
            throw new IllegalStateException(StringBundler.concat((Object[])new Object[]{"There are ", size, " possible end nodes for ", schemaVersionString}));
        }
        if (size != 0) {
            release = this.executeUpgradeInfos(bundleSymbolicName, upgradeInfosList.get(0), outputStreamContainerFactoryName);
        }
        if (release != null) {
            String schemaVersion = release.getSchemaVersion();
            if (Validator.isNull((String)schemaVersion) || requiredVersion == null) {
                return;
            }
            if (requiredVersion.compareTo(Version.parseVersion((String)schemaVersion)) > 0) {
                throw new IllegalStateException(StringBundler.concat((Object[])new Object[]{"Unable to upgrade ", bundleSymbolicName, " to ", requiredVersion, " from ", schemaVersion}));
            }
        }
    }

    public Release executeUpgradeInfos(String bundleSymbolicName, List<UpgradeInfo> upgradeInfos, String outputStreamContainerFactoryName) {
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null) {
            this._releasePublisher.publishInProgress(release);
        }
        UpgradeInfosRunnable upgradeInfosRunnable = new UpgradeInfosRunnable(bundleSymbolicName, upgradeInfos, this._swappedLogExecutor::getOutputStream);
        this._swappedLogExecutor.execute(bundleSymbolicName, upgradeInfosRunnable, outputStreamContainerFactoryName);
        release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null) {
            this._releasePublisher.publish(release);
        }
        return release;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private class UpgradeInfosRunnable
    implements Runnable {
        private static final int _STATE_IN_PROGRESS = -1;
        private final String _bundleSymbolicName;
        private final Supplier<OutputStream> _outputStreamSupplier;
        private final List<UpgradeInfo> _upgradeInfos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int buildNumber = 0;
            int state = 0;
            try {
                this._updateReleaseState(-1);
                for (UpgradeInfo upgradeInfo : this._upgradeInfos) {
                    UpgradeStep upgradeStep = upgradeInfo.getUpgradeStep();
                    upgradeStep.upgrade(new DBProcessContext(){

                        public DBContext getDBContext() {
                            return new DBContext();
                        }

                        public OutputStream getOutputStream() {
                            return (OutputStream)UpgradeInfosRunnable.this._outputStreamSupplier.get();
                        }
                    });
                    UpgradeExecutor.this._releaseLocalService.updateRelease(this._bundleSymbolicName, upgradeInfo.getToSchemaVersionString(), upgradeInfo.getFromSchemaVersionString());
                    buildNumber = upgradeInfo.getBuildNumber();
                }
            }
            catch (Exception exception) {
                state = 1;
                ReflectionUtil.throwException((Throwable)exception);
            }
            finally {
                Release release = UpgradeExecutor.this._releaseLocalService.fetchRelease(this._bundleSymbolicName);
                if (release != null) {
                    if (buildNumber > 0) {
                        release.setBuildNumber(buildNumber);
                    }
                    release.setState(state);
                    UpgradeExecutor.this._releaseLocalService.updateRelease(release);
                }
            }
            Bundle bundle = IndexUpdaterUtil.getBundle(UpgradeExecutor.this._bundleContext, this._bundleSymbolicName);
            if (this._requiresUpdateIndexes(bundle)) {
                try {
                    IndexUpdaterUtil.updateIndexes(bundle);
                }
                catch (Exception exception) {
                    _log.error((Object)exception, (Throwable)exception);
                }
            }
            CacheRegistryUtil.clear();
        }

        private UpgradeInfosRunnable(String bundleSymbolicName, List<UpgradeInfo> upgradeInfos, Supplier<OutputStream> outputStreamSupplier) {
            this._bundleSymbolicName = bundleSymbolicName;
            this._upgradeInfos = upgradeInfos;
            this._outputStreamSupplier = outputStreamSupplier;
        }

        private boolean _requiresUpdateIndexes(Bundle bundle) {
            if (!IndexUpdaterUtil.isLiferayServiceBundle(bundle)) {
                return false;
            }
            if (this._upgradeInfos.size() != 1) {
                return true;
            }
            UpgradeInfo upgradeInfo = this._upgradeInfos.get(0);
            String fromSchemaVersion = upgradeInfo.getFromSchemaVersionString();
            String upgradeStepName = String.valueOf(upgradeInfo.getUpgradeStep());
            return !fromSchemaVersion.equals("0.0.0") || !upgradeStepName.equals("Initial Database Creation");
        }

        private void _updateReleaseState(int state) {
            Release release = UpgradeExecutor.this._releaseLocalService.fetchRelease(this._bundleSymbolicName);
            if (release != null) {
                release.setState(state);
                UpgradeExecutor.this._releaseLocalService.updateRelease(release);
            }
        }
    }
}

