/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.executor;

import com.liferay.portal.output.stream.container.OutputStreamContainer;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactory;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactoryTracker;
import java.io.IOException;
import java.io.OutputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SwappedLogExecutor.class})
public class SwappedLogExecutor {
    @Reference
    private OutputStreamContainerFactoryTracker _outputStreamContainerFactoryTracker;
    private final ThreadLocal<OutputStream> _outputStreamThreadLocal = new ThreadLocal();

    public void execute(String bundleSymbolicName, Runnable runnable, String outputStreamContainerFactoryName) {
        OutputStreamContainerFactory outputStreamContainerFactory = this._outputStreamContainerFactoryTracker.getOutputStreamContainerFactory(outputStreamContainerFactoryName);
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create("upgrade-" + bundleSymbolicName);
        try (OutputStream outputStream = outputStreamContainer.getOutputStream();){
            this._outputStreamThreadLocal.set(outputStream);
            this._outputStreamContainerFactoryTracker.runWithSwappedLog(runnable, outputStreamContainer.getDescription(), outputStream);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        finally {
            this._outputStreamThreadLocal.remove();
        }
    }

    public OutputStream getOutputStream() {
        return this._outputStreamThreadLocal.get();
    }
}

