/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.apache.logging.log4j.core;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.internal.report.UpgradeReport;
import java.io.Serializable;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"appender.name=UpgradeReportLogAppender"}, service={Appender.class})
public class UpgradeReportLogAppender
implements Appender {
    private static final Logger _rootLogger = (Logger)LogManager.getRootLogger();
    private volatile boolean _started;
    private volatile UpgradeReport _upgradeReport;

    public void append(LogEvent logEvent) {
        Message message = logEvent.getMessage();
        if (logEvent.getLevel() == Level.ERROR) {
            this._upgradeReport.addErrorMessage(logEvent.getLoggerName(), message.getFormattedMessage());
        } else if (logEvent.getLevel() == Level.INFO) {
            if (Objects.equals(logEvent.getLoggerName(), UpgradeProcess.class.getName())) {
                this._upgradeReport.addEventMessage(logEvent.getLoggerName(), message.getFormattedMessage());
            }
        } else if (logEvent.getLevel() == Level.WARN) {
            this._upgradeReport.addWarningMessage(logEvent.getLoggerName(), message.getFormattedMessage());
        }
    }

    public ErrorHandler getHandler() {
        return null;
    }

    public Layout<? extends Serializable> getLayout() {
        return null;
    }

    public String getName() {
        return "UpgradeReportLogAppender";
    }

    public LifeCycle.State getState() {
        return null;
    }

    public boolean ignoreExceptions() {
        return false;
    }

    public void initialize() {
    }

    public boolean isStarted() {
        return this._started;
    }

    public boolean isStopped() {
        return !this._started;
    }

    public void setHandler(ErrorHandler handler) {
    }

    public void start() {
        this._started = true;
        this._upgradeReport = new UpgradeReport();
        _rootLogger.addAppender((Appender)this);
    }

    public void stop() {
        if (this._started) {
            this._upgradeReport = null;
        }
        this._started = false;
    }
}

