/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.apache.logging.log4j.core;

import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.internal.recorder.UpgradeRecorder;
import com.liferay.portal.upgrade.internal.report.UpgradeReport;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"appender.name=UpgradeLogAppender"}, service={Appender.class})
public class UpgradeLogAppender
implements Appender {
    private static final Logger _rootLogger = (Logger)LogManager.getRootLogger();
    private volatile boolean _started;
    @Reference
    private volatile UpgradeRecorder _upgradeRecorder;
    private UpgradeReport _upgradeReport;

    public void append(LogEvent logEvent) {
        Message message = logEvent.getMessage();
        String formattedMessage = message.getFormattedMessage();
        if (formattedMessage.equals("null")) {
            Throwable throwable = logEvent.getThrown();
            formattedMessage = throwable.getMessage();
        }
        if (logEvent.getLevel() == Level.ERROR) {
            this._upgradeRecorder.recordErrorMessage(logEvent.getLoggerName(), formattedMessage);
        } else if (logEvent.getLevel() == Level.INFO) {
            if (Objects.equals(logEvent.getLoggerName(), UpgradeProcess.class.getName()) && formattedMessage.startsWith("Completed upgrade process ")) {
                this._upgradeRecorder.recordUpgradeProcessMessage(logEvent.getLoggerName(), formattedMessage);
            }
        } else if (logEvent.getLevel() == Level.WARN) {
            this._upgradeRecorder.recordWarningMessage(logEvent.getLoggerName(), message.getFormattedMessage());
        }
    }

    public ErrorHandler getHandler() {
        return null;
    }

    public Layout<? extends Serializable> getLayout() {
        return null;
    }

    public String getName() {
        return "UpgradeLogAppender";
    }

    public LifeCycle.State getState() {
        return null;
    }

    public boolean ignoreExceptions() {
        return false;
    }

    public void initialize() {
    }

    public boolean isStarted() {
        return this._started;
    }

    public boolean isStopped() {
        return !this._started;
    }

    public void setHandler(ErrorHandler handler) {
    }

    public void start() {
        this._started = true;
        this._upgradeRecorder.start();
        if (PropsValues.UPGRADE_REPORT_ENABLED && !StartupHelperUtil.isDBNew()) {
            this._upgradeReport = new UpgradeReport();
        }
        _rootLogger.addAppender((Appender)this);
    }

    public void stop() {
        if (this._started) {
            this._upgradeRecorder.stop();
            if (PropsValues.UPGRADE_REPORT_ENABLED && !StartupHelperUtil.isDBNew()) {
                this._upgradeReport.generateReport(this._upgradeRecorder);
                this._upgradeReport = null;
            }
        }
        this._started = false;
        _rootLogger.removeAppender((Appender)this);
    }
}

