/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.executor;

import com.liferay.osgi.service.tracker.collections.EagerServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.index.IndexUpdaterUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.util.BundleUtil;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.registry.UpgradeStepRegistry;
import com.liferay.portal.upgrade.internal.release.ReleasePublisher;
import com.liferay.portal.upgrade.log.UpgradeLogContext;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={UpgradeExecutor.class})
public class UpgradeExecutor {
    private static final int _STATE_IN_PROGRESS = -1;
    private static final Log _log = LogFactoryUtil.getLog(UpgradeExecutor.class);
    private BundleContext _bundleContext;
    private boolean _portalUpgraded;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private ReleasePublisher _releasePublisher;
    private ServiceTrackerMap<String, UpgradeStepRegistry> _serviceTrackerMap;

    public void execute(Bundle bundle, List<UpgradeInfo> upgradeInfos) {
        List<List<UpgradeInfo>> upgradeInfosList;
        int size;
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(upgradeInfos);
        String schemaVersionString = "0.0.0";
        Release release = this._releaseLocalService.fetchRelease(bundle.getSymbolicName());
        if (release != null && Validator.isNotNull((String)release.getSchemaVersion())) {
            schemaVersionString = release.getSchemaVersion();
        }
        if ((size = (upgradeInfosList = releaseGraphManager.getUpgradeInfosList(schemaVersionString)).size()) > 1) {
            throw new IllegalStateException(StringBundler.concat((Object[])new Object[]{"There are ", size, " possible end nodes for ", schemaVersionString}));
        }
        if (size != 0) {
            release = this.executeUpgradeInfos(bundle, upgradeInfosList.get(0));
        }
        if (release != null) {
            String schemaVersion = release.getSchemaVersion();
            if (Validator.isNull((String)schemaVersion)) {
                return;
            }
            Dictionary headers = bundle.getHeaders("");
            Version requiredVersion = Version.parseVersion((String)((String)headers.get("Liferay-Require-SchemaVersion")));
            if (requiredVersion == null) {
                return;
            }
            if (requiredVersion.compareTo(Version.parseVersion((String)schemaVersion)) > 0) {
                throw new IllegalStateException(StringBundler.concat((Object[])new Object[]{"Unable to upgrade ", bundle.getSymbolicName(), " to ", requiredVersion, " from ", schemaVersion}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Release executeUpgradeInfos(Bundle bundle, List<UpgradeInfo> upgradeInfos) {
        String bundleSymbolicName = bundle.getSymbolicName();
        try {
            UpgradeLogContext.setContext((String)bundleSymbolicName);
            this._executeUpgradeInfos(bundle, upgradeInfos);
            Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
            if (release != null) {
                this._releasePublisher.publish(release, this._isInitialRelease(upgradeInfos));
            }
            Release release2 = release;
            return release2;
        }
        catch (Exception exception) {
            Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
            if (release != null) {
                this._releasePublisher.unpublish(release);
            }
            Release release3 = (Release)ReflectionUtil.throwException((Throwable)exception);
            return release3;
        }
        finally {
            UpgradeLogContext.clearContext();
        }
    }

    public Set<String> getBundleSymbolicNames() {
        return this._serviceTrackerMap.keySet();
    }

    public List<UpgradeInfo> getUpgradeInfos(String bundleSymbolicName) {
        UpgradeStepRegistry upgradeStepRegistry = (UpgradeStepRegistry)this._serviceTrackerMap.getService((Object)bundleSymbolicName);
        return upgradeStepRegistry.getUpgradeInfos();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        try (Connection connection = DataAccess.getConnection();){
            this._portalUpgraded = PortalUpgradeProcess.isInLatestSchemaVersion((Connection)connection);
        }
        catch (SQLException sqlException) {
            throw new RuntimeException(sqlException);
        }
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, UpgradeStepRegistrator.class, null, (serviceReference, emitter) -> {
            Bundle bundle = serviceReference.getBundle();
            emitter.emit((Object)bundle.getSymbolicName());
        }, (ServiceTrackerCustomizer)new UpgradeStepRegistratorServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _executeUpgradeInfos(Bundle bundle, List<UpgradeInfo> upgradeInfos) {
        int state = 0;
        String bundleSymbolicName = bundle.getSymbolicName();
        try {
            this._updateReleaseState(bundleSymbolicName, -1);
            for (UpgradeInfo upgradeInfo : upgradeInfos) {
                UpgradeStep upgradeStep = upgradeInfo.getUpgradeStep();
                upgradeStep.upgrade();
                this._releaseLocalService.updateRelease(bundleSymbolicName, upgradeInfo.getToSchemaVersionString(), upgradeInfo.getFromSchemaVersionString());
            }
        }
        catch (Exception exception) {
            state = 1;
            ReflectionUtil.throwException((Throwable)exception);
        }
        finally {
            Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
            if (release != null) {
                release.setVerified(false);
                release.setState(state);
                this._releaseLocalService.updateRelease(release);
            }
        }
        if (this._requiresUpdateIndexes(bundle, upgradeInfos)) {
            try {
                IndexUpdaterUtil.updateIndexes((Bundle)bundle);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        CacheRegistryUtil.clear();
    }

    private boolean _isInitialRelease(List<UpgradeInfo> upgradeInfos) {
        UpgradeInfo upgradeInfo = upgradeInfos.get(0);
        String fromSchemaVersion = upgradeInfo.getFromSchemaVersionString();
        return fromSchemaVersion.equals("0.0.0");
    }

    private boolean _requiresUpdateIndexes(Bundle bundle, List<UpgradeInfo> upgradeInfos) {
        if (!BundleUtil.isLiferayServiceBundle((Bundle)bundle)) {
            return false;
        }
        if (upgradeInfos.size() != 1) {
            return true;
        }
        return !this._isInitialRelease(upgradeInfos);
    }

    private void _updateReleaseState(String bundleSymbolicName, int state) {
        Release release = this._releaseLocalService.fetchRelease(bundleSymbolicName);
        if (release != null) {
            release.setState(state);
            this._releaseLocalService.updateRelease(release);
        }
    }

    private class UpgradeStepRegistratorServiceTrackerCustomizer
    implements EagerServiceTrackerCustomizer<UpgradeStepRegistrator, UpgradeStepRegistry> {
        private UpgradeStepRegistratorServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpgradeStepRegistry addingService(ServiceReference<UpgradeStepRegistrator> serviceReference) {
            UpgradeStepRegistry upgradeStepRegistry = new UpgradeStepRegistry(UpgradeExecutor.this._bundleContext, UpgradeExecutor.this._portalUpgraded, serviceReference);
            Bundle bundle = serviceReference.getBundle();
            String bundleSymbolicName = bundle.getSymbolicName();
            Release release = UpgradeExecutor.this._releaseLocalService.fetchRelease(bundleSymbolicName);
            if (release == null) {
                for (UpgradeStep releaseUpgradeStep : upgradeStepRegistry.getReleaseCreationUpgradeSteps()) {
                    try {
                        UpgradeLogContext.setContext((String)bundleSymbolicName);
                        releaseUpgradeStep.upgrade();
                    }
                    catch (UpgradeException upgradeException) {
                        _log.error((Throwable)upgradeException);
                    }
                    finally {
                        UpgradeLogContext.clearContext();
                    }
                }
            }
            if (DBUpgrader.isUpgradeDatabaseAutoRunEnabled() || release == null) {
                try {
                    UpgradeExecutor.this.execute(bundle, upgradeStepRegistry.getUpgradeInfos());
                }
                catch (Throwable throwable) {
                    _log.error((Object)"Failed upgrade process for module ".concat(bundleSymbolicName), throwable);
                }
            }
            return upgradeStepRegistry;
        }

        public void modifiedService(ServiceReference<UpgradeStepRegistrator> serviceReference, UpgradeStepRegistry upgradeStepRegistry) {
        }

        public void removedService(ServiceReference<UpgradeStepRegistrator> serviceReference, UpgradeStepRegistry upgradeStepRegistry) {
            upgradeStepRegistry.destroy();
        }
    }
}

