/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.recorder;

import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.ReleaseManager;
import com.liferay.portal.kernel.upgrade.recorder.UpgradeSQLRecorder;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.logging.log4j.ThreadContext;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;

@Component(service={UpgradeRecorder.class})
public class UpgradeRecorder {
    private static final String[] _FILTERED_CLASS_NAMES = new String[]{"com.liferay.portal.search.elasticsearch7.internal.sidecar.SidecarManager"};
    private static final Log _log = LogFactoryUtil.getLog(UpgradeRecorder.class);
    private static final Map<String, Map<String, Integer>> _errorMessages = new ConcurrentHashMap<String, Map<String, Integer>>();
    private static String _result;
    private static final Map<String, SchemaVersions> _schemaVersionsMap;
    private static String _type;
    private static final Map<String, ArrayList<String>> _upgradeProcessMessages;
    private static boolean _verifyProcessError;
    private static final Map<String, Map<String, Integer>> _warningMessages;
    private ServiceTracker<ReleaseManager, ReleaseManager> _serviceTracker;

    public Map<String, Map<String, Integer>> getErrorMessages() {
        return _errorMessages;
    }

    public String getFinalSchemaVersion(String servletContextName) {
        SchemaVersions schemaVersions = _schemaVersionsMap.get(servletContextName);
        if (schemaVersions == null) {
            return null;
        }
        return schemaVersions._getFinal();
    }

    public String getInitialSchemaVersion(String servletContextName) {
        SchemaVersions schemaVersions = _schemaVersionsMap.get(servletContextName);
        if (schemaVersions == null) {
            return null;
        }
        return schemaVersions._getInitial();
    }

    public String getResult() {
        return _result;
    }

    public String getType() {
        return _type;
    }

    public Map<String, ArrayList<String>> getUpgradeProcessMessages() {
        return _upgradeProcessMessages;
    }

    public Map<String, Map<String, Integer>> getWarningMessages() {
        return _warningMessages;
    }

    public void recordErrorMessage(String loggerName, String message) {
        Map messages = _errorMessages.computeIfAbsent(loggerName, key -> new ConcurrentHashMap());
        int occurrences = messages.computeIfAbsent(message, key -> 0);
        messages.put(message, ++occurrences);
        if (!_verifyProcessError && message.contains(VerifyException.class.getName())) {
            _verifyProcessError = true;
        }
    }

    public void recordUpgradeProcessMessage(String loggerName, String message) {
        List messages = _upgradeProcessMessages.computeIfAbsent(loggerName, key -> new ArrayList());
        messages.add(message);
    }

    public void recordWarningMessage(String loggerName, String message) {
        Map messages = _warningMessages.computeIfAbsent(loggerName, key -> new ConcurrentHashMap());
        int occurrences = messages.computeIfAbsent(message, key -> 0);
        messages.put(message, ++occurrences);
    }

    public void start() {
        _errorMessages.clear();
        _result = "running";
        _schemaVersionsMap.clear();
        _type = "pending";
        _upgradeProcessMessages.clear();
        _warningMessages.clear();
        this._processRelease((UnsafeBiConsumer<SchemaVersions, String, Exception>)((UnsafeBiConsumer)(moduleSchemaVersions, schemaVersion) -> moduleSchemaVersions._setInitial((String)schemaVersion)));
        UpgradeSQLRecorder.start();
    }

    public void stop() {
        UpgradeSQLRecorder.stop();
        this._filter(_errorMessages);
        this._filter(_warningMessages);
        _result = this._calculateResult();
        _type = this._calculateType(_result);
        if (PropsValues.UPGRADE_LOG_CONTEXT_ENABLED) {
            ThreadContext.put((String)"upgrade.type", (String)_type);
            ThreadContext.put((String)"upgrade.result", (String)_result);
        }
        if (_log.isInfoEnabled()) {
            if (_type.equals("no upgrade") && _result.equals("success")) {
                _log.info((Object)"No pending upgrades to run");
            } else {
                _log.info((Object)StringBundler.concat((String[])new String[]{StringUtil.upperCaseFirstLetter((String)_type), " upgrade finished with result ", _result}));
                if (!_result.equals("failure") && !_errorMessages.isEmpty()) {
                    _log.info((Object)"Unrelated errors occur during the upgrade");
                }
            }
        }
        if (PropsValues.UPGRADE_LOG_CONTEXT_ENABLED) {
            ThreadContext.clearMap();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker(bundleContext, ReleaseManager.class, null);
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        this._serviceTracker.close();
    }

    private String _calculateResult() {
        if (_verifyProcessError) {
            return "failure";
        }
        try {
            ReleaseManager releaseManager = (ReleaseManager)this._serviceTracker.getService();
            return releaseManager.getStatus();
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to check the upgrade result due to ", exception.getMessage(), ". Please check manually."}));
            return "failure";
        }
    }

    private String _calculateType(String result) {
        this._processRelease((UnsafeBiConsumer<SchemaVersions, String, Exception>)((UnsafeBiConsumer)(moduleSchemaVersions, schemaVersion) -> moduleSchemaVersions._setFinal((String)schemaVersion)));
        String type = "no upgrade";
        for (Map.Entry<String, SchemaVersions> schemaVersionsEntry : _schemaVersionsMap.entrySet()) {
            Version finalVersion;
            SchemaVersions schemaVersions = schemaVersionsEntry.getValue();
            if (schemaVersions._getInitial() == null) {
                return "major";
            }
            Version initialVersion = Version.parseVersion((String)schemaVersions._getInitial());
            if (initialVersion.equals((Object)(finalVersion = Version.parseVersion((String)schemaVersions._getFinal())))) continue;
            if (initialVersion.getMajor() < finalVersion.getMajor()) {
                return "major";
            }
            if (type.equals("minor")) continue;
            if (initialVersion.getMinor() < finalVersion.getMinor()) {
                type = "minor";
                continue;
            }
            type = "micro";
        }
        if (type.equals("no upgrade") && !result.equals("success")) {
            return "major";
        }
        return type;
    }

    private Map<String, Map<String, Integer>> _filter(Map<String, Map<String, Integer>> messages) {
        for (String filteredClassName : _FILTERED_CLASS_NAMES) {
            messages.remove(filteredClassName);
        }
        return messages;
    }

    private void _processRelease(UnsafeBiConsumer<SchemaVersions, String, Exception> unsafeBiConsumer) {
        DataSource dataSource = InfrastructureUtil.getDataSource();
        if (dataSource == null) {
            return;
        }
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select servletContextName, schemaVersion from Release_");){
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String servletContextName = resultSet.getString("servletContextName");
                String schemaVersion = resultSet.getString("schemaVersion");
                SchemaVersions moduleSchemaVersions = _schemaVersionsMap.get(servletContextName);
                if (moduleSchemaVersions == null) {
                    moduleSchemaVersions = new SchemaVersions(null);
                    _schemaVersionsMap.put(servletContextName, moduleSchemaVersions);
                }
                unsafeBiConsumer.accept((Object)moduleSchemaVersions, (Object)schemaVersion);
            }
        }
        catch (SQLException sqlException) {
            _log.error((Object)"Unable to get schema version", (Throwable)sqlException);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to process Release_ table", (Throwable)exception);
        }
    }

    static {
        _schemaVersionsMap = new ConcurrentHashMap<String, SchemaVersions>();
        _upgradeProcessMessages = new ConcurrentHashMap<String, ArrayList<String>>();
        _warningMessages = new ConcurrentHashMap<String, Map<String, Integer>>();
        if (DBUpgrader.isUpgradeDatabaseAutoRunEnabled()) {
            _result = "pending";
            _type = "pending";
        } else {
            _result = "not enabled";
            _type = "not enabled";
        }
    }

    private class SchemaVersions {
        private String _final;
        private String _initial;

        public SchemaVersions(String initial) {
            this._initial = initial;
        }

        private String _getFinal() {
            return this._final;
        }

        private String _getInitial() {
            return this._initial;
        }

        private void _setFinal(String aFinal) {
            this._final = aFinal;
        }

        private void _setInitial(String initial) {
            if (initial == null) {
                this._initial = "0.0.0";
                return;
            }
            this._initial = initial;
        }
    }
}

