/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.registry;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.kernel.upgrade.DummyUpgradeStep;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class UpgradeStepRegistry
implements UpgradeStepRegistrator.Registry {
    private final BundleContext _bundleContext;
    private boolean _initialization;
    private final boolean _portalUpgraded;
    private final List<UpgradeStep> _releaseCreationUpgradeSteps = new ArrayList<UpgradeStep>();
    private final ServiceReference<UpgradeStepRegistrator> _serviceReference;
    private final List<UpgradeInfo> _upgradeInfos = new ArrayList<UpgradeInfo>();
    private final DCLSingleton<List<UpgradeInfo>> _upgradeInfosDCLSingleton = new DCLSingleton();

    public UpgradeStepRegistry(BundleContext bundleContext, boolean portalUpgraded, ServiceReference<UpgradeStepRegistrator> serviceReference) {
        this._bundleContext = bundleContext;
        this._portalUpgraded = portalUpgraded;
        this._serviceReference = serviceReference;
    }

    public void destroy() {
        this._upgradeInfosDCLSingleton.destroy(upgradeInfos -> this._bundleContext.ungetService(this._serviceReference));
    }

    public List<UpgradeStep> getReleaseCreationUpgradeSteps() {
        this.getUpgradeInfos();
        return this._releaseCreationUpgradeSteps;
    }

    public List<UpgradeInfo> getUpgradeInfos() {
        return (List)this._upgradeInfosDCLSingleton.getSingleton(this::_getUpgradeInfos);
    }

    public void register(String fromSchemaVersionString, String toSchemaVersionString, UpgradeStep ... upgradeSteps) {
        if (ArrayUtil.isEmpty((Object[])upgradeSteps)) {
            return;
        }
        ArrayList<UpgradeStep> upgradeStepsList = new ArrayList<UpgradeStep>();
        for (UpgradeStep upgradeStep : upgradeSteps) {
            if (upgradeStep instanceof UpgradeProcess) {
                UpgradeProcess upgradeProcess = (UpgradeProcess)upgradeStep;
                for (UpgradeStep innerUpgradeStep : upgradeProcess.getUpgradeSteps()) {
                    upgradeStepsList.add(innerUpgradeStep);
                }
                continue;
            }
            upgradeStepsList.add(upgradeStep);
        }
        if (upgradeStepsList.size() == 1) {
            this._upgradeInfos.add(new UpgradeInfo(fromSchemaVersionString, toSchemaVersionString, (UpgradeStep)upgradeStepsList.get(0)));
        } else {
            this._upgradeInfos.add(new UpgradeInfo(fromSchemaVersionString, toSchemaVersionString, () -> {
                for (UpgradeStep upgradeStep : upgradeStepsList) {
                    upgradeStep.upgrade();
                }
            }));
        }
    }

    public void registerInitialization() {
        this._initialization = true;
    }

    public void registerReleaseCreationUpgradeSteps(UpgradeStep ... upgradeSteps) {
        Collections.addAll(this._releaseCreationUpgradeSteps, upgradeSteps);
    }

    private String _getFinalSchemaVersion(List<UpgradeInfo> upgradeInfos) {
        Version finalSchemaVersion = null;
        for (UpgradeInfo upgradeInfo : upgradeInfos) {
            Version schemaVersion = Version.parseVersion((String)upgradeInfo.getToSchemaVersionString());
            if (finalSchemaVersion == null) {
                finalSchemaVersion = schemaVersion;
                continue;
            }
            finalSchemaVersion = finalSchemaVersion.compareTo(schemaVersion) >= 0 ? finalSchemaVersion : schemaVersion;
        }
        return finalSchemaVersion.toString();
    }

    private List<UpgradeInfo> _getUpgradeInfos() {
        UpgradeStepRegistrator upgradeStepRegistrator = (UpgradeStepRegistrator)this._bundleContext.getService(this._serviceReference);
        upgradeStepRegistrator.register((UpgradeStepRegistrator.Registry)this);
        if (this._initialization && this._portalUpgraded) {
            if (this._upgradeInfos.isEmpty()) {
                return Arrays.asList(new UpgradeInfo("0.0.0", "1.0.0", (UpgradeStep)new DummyUpgradeStep()));
            }
            return ListUtil.concat((List[])new List[]{Arrays.asList(new UpgradeInfo("0.0.0", this._getFinalSchemaVersion(this._upgradeInfos), (UpgradeStep)new DummyUpgradeStep())), this._upgradeInfos});
        }
        return this._upgradeInfos;
    }
}

