/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.ReleaseManager;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.osgi.debug.SystemChecker;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.upgrade.internal.executor.UpgradeExecutor;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.release.ReleasePublisher;
import com.liferay.portal.upgrade.internal.release.util.ReleaseManagerUtil;
import com.liferay.portal.upgrade.release.SchemaCreator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={ReleaseManager.class})
public class ReleaseManagerImpl
implements ReleaseManager {
    private static final Log _log = LogFactoryUtil.getLog(ReleaseManagerImpl.class);
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private ReleasePublisher _releasePublisher;
    private ServiceTracker<SchemaCreator, Release> _schemaCreatorServiceTracker;
    @Reference(target="(component.name=com.liferay.portal.osgi.debug.declarative.service.internal.DeclarativeServiceUnsatisfiedComponentSystemChecker)")
    private volatile SystemChecker _systemChecker;
    @Reference
    private UpgradeExecutor _upgradeExecutor;

    public String getShortStatusMessage(boolean onlyRequiredUpgrades) {
        Object where;
        String message;
        block13: {
            message = "%s upgrades in %s are pending. Run the upgrade process or type upgrade:checkAll in the Gogo shell to get more information.";
            if (onlyRequiredUpgrades) {
                if (this._isPendingRequiredModuleUpgrades()) {
                    return String.format(message, "Required", "modules");
                }
                return "";
            }
            where = "";
            try (Connection connection = DataAccess.getConnection();){
                if (!PortalUpgradeProcess.isInLatestSchemaVersion((Connection)connection)) {
                    where = "portal";
                }
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block13;
                _log.warn((Object)"Unable to get pending upgrade information for the portal", (Throwable)sqlException);
            }
        }
        if (this._isPendingModuleUpgrades()) {
            where = Validator.isNotNull((String)where) ? "and " + (String)where : "modules";
        }
        if (Validator.isNotNull((String)where)) {
            return String.format(message, "Optional", where);
        }
        return "";
    }

    public String getStatus() throws Exception {
        try (Connection connection = DataAccess.getConnection();){
            if (!PortalUpgradeProcess.isInLatestSchemaVersion((Connection)connection) || this._isPendingModuleUpgrades()) {
                String string = "failure";
                return string;
            }
        }
        if (this._hasUnsatisfiedUpgradeComponents()) {
            return "unresolved";
        }
        return "success";
    }

    public String getStatusMessage(boolean showUpgradeSteps) {
        StringBundler sb = new StringBundler(6);
        sb.append(this._checkPortal(showUpgradeSteps));
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(this._checkModules(showUpgradeSteps));
        if (this._hasUnsatisfiedUpgradeComponents()) {
            sb.append("Unsatisfied components prevent upgrade processes to ");
            sb.append("be registered");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._schemaCreatorServiceTracker = new ServiceTracker(bundleContext, SchemaCreator.class, (ServiceTrackerCustomizer)new SchemaCreatorServiceTrackerCustomizer(bundleContext));
        this._schemaCreatorServiceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._schemaCreatorServiceTracker.close();
    }

    private String _checkModules(boolean showUpgradeSteps) {
        StringBundler sb = new StringBundler();
        Set<String> bundleSymbolicNames = this._upgradeExecutor.getBundleSymbolicNames();
        for (String bundleSymbolicName : bundleSymbolicNames) {
            String schemaVersionString = ReleaseManagerUtil.getSchemaVersionString(this._releaseLocalService.fetchRelease(bundleSymbolicName));
            ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(this._upgradeExecutor.getUpgradeInfos(bundleSymbolicName));
            List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(schemaVersionString);
            int size = upgradeInfosList.size();
            if (size > 1) {
                sb.append("There are ");
                sb.append(size);
                sb.append(" possible end nodes for ");
                sb.append(schemaVersionString);
                sb.append("\n");
            }
            if (size == 0) continue;
            List<UpgradeInfo> upgradeInfos = upgradeInfosList.get(0);
            UpgradeInfo lastUpgradeInfo = upgradeInfos.get(upgradeInfos.size() - 1);
            sb.append(this._getModulePendingUpgradeMessage(bundleSymbolicName, schemaVersionString, lastUpgradeInfo.getToSchemaVersionString()));
            if (showUpgradeSteps) {
                sb.append(":");
                for (UpgradeInfo upgradeInfo : upgradeInfos) {
                    UpgradeStep upgradeStep = upgradeInfo.getUpgradeStep();
                    sb.append("\n");
                    sb.append("\t");
                    sb.append(this._getPendingUpgradeProcessMessage(upgradeStep.getClass(), upgradeInfo.getFromSchemaVersionString(), upgradeInfo.getToSchemaVersionString()));
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _checkPortal(boolean showUpgradeSteps) {
        try (Connection connection = DataAccess.getConnection();){
            Version currentSchemaVersion = PortalUpgradeProcess.getCurrentSchemaVersion((Connection)connection);
            SortedMap pendingUpgradeProcesses = PortalUpgradeProcess.getPendingUpgradeProcesses((Version)currentSchemaVersion);
            if (pendingUpgradeProcesses.isEmpty()) return "";
            Version latestSchemaVersion = PortalUpgradeProcess.getLatestSchemaVersion();
            StringBundler sb = new StringBundler();
            sb.append(this._getModulePendingUpgradeMessage("Portal", currentSchemaVersion.toString(), latestSchemaVersion.toString()));
            sb.append(" (requires upgrade tool or auto upgrade)");
            if (showUpgradeSteps) {
                sb.append(":");
                for (Map.Entry entry : pendingUpgradeProcesses.entrySet()) {
                    sb.append("\n");
                    sb.append("\t");
                    List upgradeProcesses = (List)entry.getValue();
                    Version version = (Version)entry.getKey();
                    sb.append(this._getPendingUpgradeProcessMessage(upgradeProcesses.getClass(), currentSchemaVersion.toString(), version.toString()));
                    sb.append("\n");
                    currentSchemaVersion = version;
                }
            }
            String string = sb.toString();
            return string;
        }
        catch (SQLException sqlException) {
            if (!_log.isWarnEnabled()) return "";
            _log.warn((Object)"Unable to get pending upgrade information for the portal", (Throwable)sqlException);
        }
        return "";
    }

    private String _getModulePendingUpgradeMessage(String moduleName, String currentSchemaVersion, String finalSchemaVersion) {
        return StringBundler.concat((String[])new String[]{"There are upgrade processes available for ", moduleName, " from ", currentSchemaVersion, " to ", finalSchemaVersion});
    }

    private String _getPendingUpgradeProcessMessage(Class<?> upgradeClass, String fromSchemaVersion, String toSchemaVersion) {
        StringBundler sb = new StringBundler(6);
        Object toMessage = toSchemaVersion;
        if (UpgradeProcessUtil.isRequiredSchemaVersion((Version)Version.parseVersion((String)fromSchemaVersion), (Version)Version.parseVersion((String)toSchemaVersion))) {
            toMessage = (String)toMessage + " (REQUIRED)";
        }
        sb.append(fromSchemaVersion);
        sb.append(" to ");
        sb.append((String)toMessage);
        sb.append(":");
        sb.append(" ");
        sb.append(upgradeClass.getName());
        return sb.toString();
    }

    private boolean _hasUnsatisfiedUpgradeComponents() {
        String result = this._systemChecker.check();
        return result.contains("UpgradeStepRegistrator");
    }

    private boolean _isPendingModuleUpgrades() {
        for (String bundleSymbolicName : this._upgradeExecutor.getBundleSymbolicNames()) {
            if (!ReleaseManagerUtil.isUpgradable(bundleSymbolicName, this._releaseLocalService, this._upgradeExecutor)) continue;
            return true;
        }
        return false;
    }

    private boolean _isPendingRequiredModuleUpgrades() {
        Set<String> upgradableBundleSymbolicNames = ReleaseManagerUtil.getUpgradableBundleSymbolicNames(this._upgradeExecutor.getBundleSymbolicNames(), this._releaseLocalService, this._upgradeExecutor);
        for (String bundleSymbolicName : upgradableBundleSymbolicNames) {
            ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(this._upgradeExecutor.getUpgradeInfos(bundleSymbolicName));
            List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(ReleaseManagerUtil.getSchemaVersionString(this._releaseLocalService.fetchRelease(bundleSymbolicName)));
            List<UpgradeInfo> upgradeInfos = upgradeInfosList.get(0);
            for (UpgradeInfo upgradeInfo : upgradeInfos) {
                if (!UpgradeProcessUtil.isRequiredSchemaVersion((Version)Version.parseVersion((String)upgradeInfo.getFromSchemaVersionString()), (Version)Version.parseVersion((String)upgradeInfo.getToSchemaVersionString()))) continue;
                return true;
            }
        }
        return false;
    }

    private class SchemaCreatorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SchemaCreator, Release> {
        private final BundleContext _bundleContext;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Release addingService(ServiceReference<SchemaCreator> serviceReference) {
            SchemaCreator schemaCreator = (SchemaCreator)this._bundleContext.getService(serviceReference);
            String bundleSymbolicName = schemaCreator.getBundleSymbolicName();
            Release release = ReleaseManagerImpl.this._releaseLocalService.fetchRelease(bundleSymbolicName);
            if (release == null || StringUtil.equals((String)"0.0.0", (String)release.getSchemaVersion())) {
                try {
                    schemaCreator.create();
                    release = ReleaseManagerImpl.this._releaseLocalService.updateRelease(bundleSymbolicName, schemaCreator.getSchemaVersion(), "0.0.0");
                    release.setVerified(false);
                }
                catch (Exception exception) {
                    release = ReleaseManagerImpl.this._releaseLocalService.addRelease(bundleSymbolicName, "0.0.0");
                    release.setState(1);
                    ReflectionUtil.throwException((Throwable)exception);
                }
                finally {
                    release = ReleaseManagerImpl.this._releaseLocalService.updateRelease(release);
                    ReleaseManagerImpl.this._releasePublisher.publish(release, true);
                }
            }
            return release;
        }

        public void modifiedService(ServiceReference<SchemaCreator> serviceReference, Release release) {
        }

        public void removedService(ServiceReference<SchemaCreator> serviceReference, Release release) {
        }

        private SchemaCreatorServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }
    }
}

