/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.internal.model.listener.ReleaseModelListener;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ReleasePublisher.class})
public class ReleasePublisher {
    private static final Log _log = LogFactoryUtil.getLog(ReleasePublisher.class);
    private BundleContext _bundleContext;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    private final Map<String, ServiceRegistration<Release>> _serviceConfiguratorRegistrations = new HashMap<String, ServiceRegistration<Release>>();
    private ServiceRegistration<?> _serviceRegistration;

    public void publish(Release release, boolean initialRelease) {
        Hashtable<String, Object> properties;
        block4: {
            properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("release.bundle.symbolic.name", release.getBundleSymbolicName());
            ((Dictionary)properties).put("release.initial", initialRelease);
            try {
                if (Validator.isNotNull((String)release.getSchemaVersion())) {
                    Version version = new Version(release.getSchemaVersion());
                    ((Dictionary)properties).put("release.schema.version", version);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Invalid schema version for release: " + release), (Throwable)illegalArgumentException);
            }
        }
        ServiceRegistration<Release> oldServiceRegistration = this._serviceConfiguratorRegistrations.put(release.getServletContextName(), (ServiceRegistration<Release>)this._bundleContext.registerService(Release.class, (Object)release, properties));
        if (oldServiceRegistration != null) {
            oldServiceRegistration.unregister();
        }
    }

    public void unpublish(Release release) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            ServiceRegistration<Release> serviceRegistration = this._serviceConfiguratorRegistrations.remove(release.getServletContextName());
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
            return null;
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        List releases = this._releaseLocalService.getReleases(-1, -1);
        for (Release release : releases) {
            if (release.getState() != 0) continue;
            this.publish(release, false);
        }
        this._serviceRegistration = bundleContext.registerService(ModelListener.class, (Object)new ReleaseModelListener(this), null);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
        for (ServiceRegistration<Release> serviceRegistration : this._serviceConfiguratorRegistrations.values()) {
            serviceRegistration.unregister();
        }
    }
}

