/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release.osgi.commands;

import com.liferay.gogo.shell.logging.TeeLoggingUtil;
import com.liferay.osgi.util.osgi.commands.OSGiCommands;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.BundleUtil;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.ReleaseManager;
import com.liferay.portal.upgrade.internal.executor.UpgradeExecutor;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import com.liferay.portal.upgrade.internal.release.util.ReleaseManagerUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.command.function=check", "osgi.command.function=checkAll", "osgi.command.function=execute", "osgi.command.function=executeAll", "osgi.command.function=list", "osgi.command.scope=upgrade"}, service={OSGiCommands.class})
public class ReleaseManagerOSGiCommands
implements OSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(ReleaseManagerOSGiCommands.class);
    private BundleContext _bundleContext;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private ReleaseManager _releaseManager;
    @Reference
    private UpgradeExecutor _upgradeExecutor;

    @Descriptor(value="List pending upgrades")
    public String check() {
        return this._releaseManager.getStatusMessage(false);
    }

    @Descriptor(value="List pending upgrade processes and their upgrade steps")
    public String checkAll() {
        return this._releaseManager.getStatusMessage(true);
    }

    @Descriptor(value="Execute upgrade for a specific module")
    public String execute(String bundleSymbolicName) {
        List<UpgradeInfo> upgradeInfos = this._upgradeExecutor.getUpgradeInfos(bundleSymbolicName);
        if (upgradeInfos == null) {
            return "No upgrade processes registered for " + bundleSymbolicName;
        }
        TeeLoggingUtil.runWithTeeLogging(() -> {
            try {
                this._upgradeExecutor.execute(BundleUtil.getBundle((BundleContext)this._bundleContext, (String)bundleSymbolicName), upgradeInfos);
            }
            catch (Throwable throwable) {
                _log.error((Object)"Failed upgrade process for module ".concat(bundleSymbolicName), throwable);
            }
        });
        return null;
    }

    @Descriptor(value="Execute upgrade for a specific module and final version")
    public String execute(String bundleSymbolicName, String toVersionString) {
        List<UpgradeInfo> upgradeInfos = this._upgradeExecutor.getUpgradeInfos(bundleSymbolicName);
        if (upgradeInfos == null) {
            return "No upgrade processes registered for " + bundleSymbolicName;
        }
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(upgradeInfos);
        TeeLoggingUtil.runWithTeeLogging(() -> this._upgradeExecutor.executeUpgradeInfos(BundleUtil.getBundle((BundleContext)this._bundleContext, (String)bundleSymbolicName), releaseGraphManager.getUpgradeInfos(ReleaseManagerUtil.getSchemaVersionString(this._releaseLocalService.fetchRelease(bundleSymbolicName)), toVersionString)));
        return null;
    }

    @Descriptor(value="Execute all pending upgrades")
    public String executeAll() {
        HashSet upgradeThrewExceptionBundleSymbolicNames = new HashSet();
        TeeLoggingUtil.runWithTeeLogging(() -> this.executeAll(upgradeThrewExceptionBundleSymbolicNames));
        if (upgradeThrewExceptionBundleSymbolicNames.isEmpty()) {
            return "All modules were successfully upgraded";
        }
        StringBundler sb = new StringBundler(upgradeThrewExceptionBundleSymbolicNames.size() * 3 + 3);
        sb.append("The following modules had errors while upgrading:\n");
        for (String upgradeThrewExceptionBundleSymbolicName : upgradeThrewExceptionBundleSymbolicNames) {
            sb.append("\t");
            sb.append(upgradeThrewExceptionBundleSymbolicName);
            sb.append("\n");
        }
        sb.append("Use the command upgrade:list <module name> to get more ");
        sb.append("details about the status of a specific upgrade.");
        return sb.toString();
    }

    @Descriptor(value="List registered upgrade processes for all modules")
    public String list() {
        Set<String> bundleSymbolicNames = this._upgradeExecutor.getBundleSymbolicNames();
        StringBundler sb = new StringBundler(2 * bundleSymbolicNames.size());
        for (String bundleSymbolicName : bundleSymbolicNames) {
            sb.append(this.list(bundleSymbolicName));
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    @Descriptor(value="List registered upgrade processes for a specific module")
    public String list(String bundleSymbolicName) {
        List<UpgradeInfo> upgradeInfos = this._upgradeExecutor.getUpgradeInfos(bundleSymbolicName);
        StringBundler sb = new StringBundler(5 + 3 * upgradeInfos.size());
        sb.append("Registered upgrade processes for ");
        sb.append(bundleSymbolicName);
        sb.append(" ");
        sb.append(ReleaseManagerUtil.getSchemaVersionString(this._releaseLocalService.fetchRelease(bundleSymbolicName)));
        sb.append("\n");
        for (UpgradeInfo upgradeProcess : upgradeInfos) {
            sb.append("\t");
            sb.append((Object)upgradeProcess);
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    protected void executeAll(Set<String> upgradeThrewExceptionBundleSymbolicNames) {
        block2: while (true) {
            Set<String> upgradableBundleSymbolicNames = ReleaseManagerUtil.getUpgradableBundleSymbolicNames(this._upgradeExecutor.getBundleSymbolicNames(), this._releaseLocalService, this._upgradeExecutor);
            upgradableBundleSymbolicNames.removeAll(upgradeThrewExceptionBundleSymbolicNames);
            if (upgradableBundleSymbolicNames.isEmpty()) {
                return;
            }
            Iterator<String> iterator = upgradableBundleSymbolicNames.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                String upgradableBundleSymbolicName = iterator.next();
                try {
                    List<UpgradeInfo> upgradeInfos = this._upgradeExecutor.getUpgradeInfos(upgradableBundleSymbolicName);
                    this._upgradeExecutor.execute(BundleUtil.getBundle((BundleContext)this._bundleContext, (String)upgradableBundleSymbolicName), upgradeInfos);
                    continue;
                }
                catch (Throwable throwable) {
                    _log.error((Object)"Failed upgrade process for module ".concat(upgradableBundleSymbolicName), throwable);
                    upgradeThrewExceptionBundleSymbolicNames.add(upgradableBundleSymbolicName);
                    continue;
                }
                break;
            }
            break;
        }
    }
}

