/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.release.util;

import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.internal.executor.UpgradeExecutor;
import com.liferay.portal.upgrade.internal.graph.ReleaseGraphManager;
import com.liferay.portal.upgrade.internal.registry.UpgradeInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReleaseManagerUtil {
    public static String getSchemaVersionString(Release release) {
        if (release != null && Validator.isNotNull((String)release.getSchemaVersion())) {
            return release.getSchemaVersion();
        }
        return "0.0.0";
    }

    public static Set<String> getUpgradableBundleSymbolicNames(Set<String> bundleSymbolicNames, ReleaseLocalService releaseLocalService, UpgradeExecutor upgradeExecutor) {
        HashSet<String> upgradableBundleSymbolicNames = new HashSet<String>();
        for (String bundleSymbolicName : bundleSymbolicNames) {
            if (!ReleaseManagerUtil.isUpgradable(bundleSymbolicName, releaseLocalService, upgradeExecutor)) continue;
            upgradableBundleSymbolicNames.add(bundleSymbolicName);
        }
        return upgradableBundleSymbolicNames;
    }

    public static boolean isUpgradable(String bundleSymbolicName, ReleaseLocalService releaseLocalService, UpgradeExecutor upgradeExecutor) {
        ReleaseGraphManager releaseGraphManager = new ReleaseGraphManager(upgradeExecutor.getUpgradeInfos(bundleSymbolicName));
        List<List<UpgradeInfo>> upgradeInfosList = releaseGraphManager.getUpgradeInfosList(ReleaseManagerUtil.getSchemaVersionString(releaseLocalService.fetchRelease(bundleSymbolicName)));
        return upgradeInfosList.size() == 1;
    }
}

