/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.internal.report;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.upgrade.ReleaseManager;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.recorder.UpgradeSQLRecorder;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.EnvPropertiesUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.upgrade.internal.recorder.UpgradeRecorder;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.felix.cm.PersistenceManager;
import org.apache.logging.log4j.ThreadContext;

public class UpgradeReport {
    private static final String _CONFIGURATION_PID_ADVANCED_FILE_SYSTEM_STORE = "com.liferay.portal.store.file.system.configuration.AdvancedFileSystemStoreConfiguration";
    private static final String _CONFIGURATION_PID_FILE_SYSTEM_STORE = "com.liferay.portal.store.file.system.configuration.FileSystemStoreConfiguration";
    private static final int _LONGEST_RUNNING_SQLS_COUNT = 20;
    private static final int _LONGEST_UPGRADE_PROCESSES_COUNT = 20;
    private static final Log _log = LogFactoryUtil.getLog(UpgradeReport.class);
    private static boolean _logContext;
    private static final Snapshot<PersistenceManager> _persistenceManagerSnapshot;
    private static final Snapshot<ReleaseManager> _releaseManagerSnapshot;
    private double _dlSize;
    private final Thread _dlSizeThread = new DLSizeThread();
    private String _executionDateString;
    private String _executionTimeString;
    private final int _initialBuildNumber = this._getBuildNumber();
    private Map<String, Integer> _initialTableCounts;
    private String _rootDir;

    public UpgradeReport() {
        if (StartupHelperUtil.isNewRelease()) {
            this._initialTableCounts = this._getTableCounts();
        }
    }

    public void generateReport(UpgradeRecorder upgradeRecorder) {
        if (StringUtil.equals((String)upgradeRecorder.getType(), (String)"no upgrade")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Upgrade report was not generated because no upgrade processes were executed");
            }
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Starting upgrade report generation");
        }
        this._executionDateString = this._getExecutionDateString();
        this._executionTimeString = DBUpgrader.getUpgradeTime() / 1000L + " seconds";
        this._rootDir = this._getRootDir();
        Map<String, Object> reportData = this._getReportData(upgradeRecorder);
        Map<String, Object> reportDataDiagnostics = this._getReportDataDiagnostics(upgradeRecorder);
        this._printToLogContext(reportData);
        this._writeToFile(reportData, "upgrade_report.txt");
        this._printToLogContext(reportDataDiagnostics);
        this._writeToFile(reportDataDiagnostics, "upgrade_report_diagnostics.txt");
    }

    private int _getBuildNumber() {
        int n;
        block9: {
            Connection connection = DataAccess.getConnection();
            try {
                n = PortalUpgradeProcess.getCurrentBuildNumber((Connection)connection);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Unable to get build number", (Throwable)exception);
                    }
                    return 0;
                }
            }
            connection.close();
        }
        return n;
    }

    private String _getExecutionDateString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM dd, yyyy hh:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance();
        return simpleDateFormat.format(calendar.getTime());
    }

    private List<MessagesPrinter> _getMessagesPrinters(Map<String, Map<String, Integer>> map1) {
        ArrayList<MessagesPrinter> messagesPrinters = new ArrayList<MessagesPrinter>();
        ArrayList<Map.Entry<String, Map<String, Integer>>> list = new ArrayList<Map.Entry<String, Map<String, Integer>>>();
        list.addAll(map1.entrySet());
        ListUtil.sort(list, Collections.reverseOrder(Map.Entry.comparingByValue(Comparator.comparingInt(Map::size))));
        for (Map.Entry entry : list) {
            MessagesPrinter messagesPrinter = new MessagesPrinter((String)entry.getKey());
            messagesPrinters.add(messagesPrinter);
            Map map2 = (Map)entry.getValue();
            for (Map.Entry entry2 : map2.entrySet()) {
                messagesPrinter.addMessagePrinter((String)entry2.getKey(), (Integer)entry2.getValue());
            }
        }
        return messagesPrinters;
    }

    private Set<String> _getPropertiesFilePathStrings() {
        TreeSet<String> propertiesFilePathStrings = new TreeSet<String>();
        for (String loadedSource : PropsUtil.getLoadedSources()) {
            try {
                String propertiesFilePathString;
                URI uri = new URI(loadedSource);
                if (!StringUtil.equals((String)"file", (String)uri.getScheme()) || !FileUtil.exists((String)(propertiesFilePathString = String.valueOf(Paths.get(uri))))) continue;
                propertiesFilePathStrings.add(propertiesFilePathString);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)exception);
            }
        }
        return propertiesFilePathStrings;
    }

    private Map<String, Object> _getReportData(UpgradeRecorder upgradeRecorder) {
        Set<String> propertiesFilePathStrings = this._getPropertiesFilePathStrings();
        return LinkedHashMapBuilder.put((Object)"execution.date", (Object)this._executionDateString).put((Object)"execution.time", (Object)this._executionTimeString).put((Object)"result", (Object)upgradeRecorder.getResult()).put((Object)"status", () -> {
            ReleaseManager releaseManager = (ReleaseManager)_releaseManagerSnapshot.get();
            if (releaseManager == null) {
                return "Upgrade failed to complete";
            }
            String statusMessage = releaseManager.getStatusMessage(false);
            if (statusMessage.isEmpty()) {
                return "There are no pending upgrades";
            }
            return statusMessage;
        }).put((Object)"type", (Object)upgradeRecorder.getType()).put((Object)"portal", (Object)LinkedHashMapBuilder.put((Object)"initial.build.number", (Object)(this._initialBuildNumber != 0 ? String.valueOf(this._initialBuildNumber) : "Unable to determine")).put((Object)"initial.schema.version", () -> {
            String initialSchemaVersion = upgradeRecorder.getInitialSchemaVersion("portal");
            if (initialSchemaVersion != null && !initialSchemaVersion.equals("0.0.0")) {
                return initialSchemaVersion;
            }
            return "Unable to determine";
        }).put((Object)"final.build.number", () -> {
            int buildNumber = this._getBuildNumber();
            if (buildNumber != 0) {
                return String.valueOf(buildNumber);
            }
            return "Unable to determine";
        }).put((Object)"final.schema.version", () -> {
            String schemaVersion = upgradeRecorder.getFinalSchemaVersion("portal");
            if (schemaVersion != null) {
                return schemaVersion;
            }
            return "Unable to determine";
        }).put((Object)"expected.build.number", () -> {
            int buildNumber = ReleaseInfo.getBuildNumber();
            if (buildNumber != 0) {
                return String.valueOf(buildNumber);
            }
            return "Unable to determine";
        }).put((Object)"expected.schema.version", () -> {
            String schemaVersion = String.valueOf(PortalUpgradeProcess.getLatestSchemaVersion());
            if (schemaVersion != null) {
                return schemaVersion;
            }
            return "Unable to determine";
        }).build()).put((Object)"database.version", () -> {
            DB db = DBManagerUtil.getDB();
            return StringBundler.concat((Object[])new Object[]{db.getDBType(), " ", db.getMajorVersion(), ".", db.getMinorVersion()});
        }).put((Object)"document.library", (Object)LinkedHashMapBuilder.put((Object)"root.directory", (Object)(this._rootDir != null ? this._rootDir : "Undefined")).put((Object)"storage.implementation", (Object)PropsValues.DL_STORE_IMPL).put((Object)"storage.size", () -> {
            if (PropsValues.UPGRADE_REPORT_DL_STORAGE_SIZE_TIMEOUT == 0L) {
                return "Disabled";
            }
            if (!StringUtil.endsWith((String)PropsValues.DL_STORE_IMPL, (String)"FileSystemStore")) {
                return "Check externally";
            }
            if (this._rootDir == null) {
                return "Unable to determine. Document library \"rootDir\" was not set";
            }
            this._dlSize = 0.0;
            try {
                this._dlSizeThread.start();
                this._dlSizeThread.join(PropsValues.UPGRADE_REPORT_DL_STORAGE_SIZE_TIMEOUT * 1000L);
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to determine the document library size", (Throwable)exception);
                return "Unable to determine";
            }
            if (this._dlSizeThread.isAlive()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Unable to determine the document library size. Increase the timeout or check it manually.");
                }
                return "Unable to determine";
            }
            return LanguageUtil.formatStorageSize((double)this._dlSize, (Locale)LocaleUtil.US);
        }).build()).put((Object)"liferay.home", (Object)PropsValues.LIFERAY_HOME).put((Object)"jvm.arguments", () -> {
            ArrayList<String> jvmArguments = new ArrayList<String>();
            String[] keywords = new String[]{"password", "secret", "securitycredential"};
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            for (String inputArgument : runtimeMXBean.getInputArguments()) {
                if (!inputArgument.startsWith("-D") || !inputArgument.contains("=")) {
                    jvmArguments.add(inputArgument);
                    continue;
                }
                String keyValueString = inputArgument.substring(2);
                String[] keyValue = keyValueString.split("=", 2);
                String key = keyValue[0];
                String value = keyValue[1];
                for (String keyword : keywords) {
                    if (!StringUtil.containsIgnoreCase((String)key, (String)keyword, (String)"")) continue;
                    value = "********";
                    break;
                }
                jvmArguments.add(StringBundler.concat((String[])new String[]{"-D", key, "=", value}));
            }
            return ListUtil.sort(jvmArguments);
        }).put((Object)"properties", () -> {
            TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
            for (String propertiesFilePathString : propertiesFilePathStrings) {
                Properties properties = new Properties();
                try (FileInputStream fileInputStream = new FileInputStream(propertiesFilePathString);){
                    properties.load(fileInputStream);
                }
                catch (IOException iOException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to load properties file from: " + propertiesFilePathString), (Throwable)iOException);
                    continue;
                }
                for (String key : properties.stringPropertyNames()) {
                    propertiesMap.put(key, PropsUtil.get((String)key));
                }
            }
            String envPrefix = "LIFERAY_";
            Map<String, String> env = System.getenv();
            for (Map.Entry entry : env.entrySet()) {
                String key;
                key = (String)entry.getKey();
                if (!key.startsWith(envPrefix)) continue;
                propertiesMap.put(EnvPropertiesUtil.decode((String)StringUtil.toLowerCase((String)key.substring(envPrefix.length()))), (String)entry.getValue());
            }
            ArrayList<PropertyPrinter> propertyPrinters = new ArrayList<PropertyPrinter>();
            for (Map.Entry entry : propertiesMap.entrySet()) {
                propertyPrinters.add(new PropertyPrinter((String)entry.getKey(), (String)entry.getValue()));
            }
            return propertyPrinters;
        }).put((Object)"properties.files", propertiesFilePathStrings).put((Object)"tables.initial.final.rows", () -> {
            Map<String, Integer> finalTableCounts = this._getTableCounts();
            if (finalTableCounts == null || this._initialTableCounts == null) {
                return null;
            }
            ArrayList<TablePrinter> tablePrinters = new ArrayList<TablePrinter>();
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.addAll(this._initialTableCounts.keySet());
            tableNames.addAll(finalTableCounts.keySet());
            ListUtil.distinct(tableNames, (tableName1, tableName2) -> {
                int initialTableCount2;
                int initialTableCount1 = this._initialTableCounts.getOrDefault(tableName1, 0);
                if (initialTableCount1 != (initialTableCount2 = this._initialTableCounts.getOrDefault(tableName2, 0).intValue())) {
                    return initialTableCount2 - initialTableCount1;
                }
                return tableName1.compareTo((String)tableName2);
            });
            for (String tableName : tableNames) {
                int finalTableCount = finalTableCounts.getOrDefault(tableName, -1);
                int initialTableCount = this._initialTableCounts.getOrDefault(tableName, -1);
                if (finalTableCount <= 0 && initialTableCount <= 0) continue;
                tablePrinters.add(new TablePrinter(finalTableCount >= 0 ? String.valueOf(finalTableCount) : "-", initialTableCount >= 0 ? String.valueOf(initialTableCount) : "-", tableName));
            }
            return tablePrinters;
        }).build();
    }

    private Map<String, Object> _getReportDataDiagnostics(UpgradeRecorder upgradeRecorder) {
        return LinkedHashMapBuilder.put((Object)"execution.date", (Object)this._executionDateString).put((Object)"execution.time", (Object)this._executionTimeString).put((Object)"errors", this._getMessagesPrinters(upgradeRecorder.getErrorMessages())).put((Object)"failed.sqls", (Object)UpgradeSQLRecorder.getFailedSQLs()).put((Object)"longest.upgrade.processes", () -> {
            Map<String, ArrayList<String>> eventMessages = upgradeRecorder.getUpgradeProcessMessages();
            List messages = eventMessages.get(UpgradeProcess.class.getName());
            if (ListUtil.isEmpty((List)messages)) {
                return new ArrayList();
            }
            HashMap<String, Long> upgradeProcessDurations = new HashMap<String, Long>();
            for (String message : messages) {
                long duration;
                int endIndex;
                int startIndex;
                String className = message.substring(startIndex = message.indexOf("com."), endIndex = message.indexOf(" ", startIndex));
                if (className.equals(PortalUpgradeProcess.class.getName()) || (duration = GetterUtil.getLong((String)message.substring(startIndex = message.indexOf(" ", endIndex + 1), endIndex = message.indexOf(" ", startIndex + 1)))) < PropsValues.UPGRADE_REPORT_UPGRADE_PROCESS_THRESHOLD) continue;
                upgradeProcessDurations.put(className, duration);
            }
            ArrayList<RunningUpgradeProcess> longestRunningUpgradeProcesses = new ArrayList<RunningUpgradeProcess>();
            int count = 0;
            for (Map.Entry entry : ListUtil.sort(new ArrayList(upgradeProcessDurations.entrySet()), Collections.reverseOrder(Map.Entry.comparingByValue(Long::compare)))) {
                longestRunningUpgradeProcesses.add(new RunningUpgradeProcess(String.valueOf(entry.getValue()), (String)entry.getKey()));
                if (++count < 20) continue;
                break;
            }
            return longestRunningUpgradeProcesses;
        }).put((Object)"longest.running.sqls", () -> {
            ArrayList runningSQLs = new ArrayList(UpgradeSQLRecorder.getRunningSQLs());
            runningSQLs.sort((entry1, entry2) -> Long.compare(entry2.getDuration(), entry1.getDuration()));
            return ListUtil.subList(runningSQLs, (int)0, (int)Math.min(20, runningSQLs.size()));
        }).put((Object)"warnings", this._getMessagesPrinters(upgradeRecorder.getWarningMessages())).build();
    }

    private File _getReportFile(String reportFileName) {
        File reportFile;
        File reportsDir = null;
        if (!(Validator.isBlank((String)PropsValues.UPGRADE_REPORT_DIR) || ((reportsDir = new File(PropsValues.UPGRADE_REPORT_DIR)).exists() || reportsDir.mkdir()) && Files.isWritable(reportsDir.toPath()))) {
            reportsDir = null;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to generate the upgrade report at " + PropsValues.UPGRADE_REPORT_DIR));
            }
        }
        if (reportsDir == null && !(reportsDir = DBUpgrader.isUpgradeClient() ? new File(".", "reports") : new File(PropsValues.LIFERAY_HOME, "reports")).exists()) {
            reportsDir.mkdirs();
        }
        if ((reportFile = new File(reportsDir, reportFileName)).exists()) {
            reportFile.renameTo(new File(reportsDir, reportFileName + "." + reportFile.lastModified()));
            reportFile = new File(reportsDir, reportFileName);
        }
        return reportFile;
    }

    private String _getReportHeader(String key) {
        if (key.equals("longest.running.sqls")) {
            return String.format("Top %d longest running SQLs above %d milliseconds", 20, PropsValues.UPGRADE_REPORT_SQL_STATEMENT_THRESHOLD);
        }
        if (key.equals("longest.upgrade.processes")) {
            return String.format("Top %d longest upgrade processes above %d milliseconds", 20, PropsValues.UPGRADE_REPORT_UPGRADE_PROCESS_THRESHOLD);
        }
        if (key.startsWith("tables.")) {
            return String.format("%-30s %20s %20s", "Table Name", "Initial Rows", "Final Rows");
        }
        return StringUtil.replace((String)StringUtil.upperCaseFirstLetter((String)key), (char)'.', (char)' ');
    }

    private String _getReportLine(String key, Object value) {
        return StringBundler.concat((Object[])new Object[]{this._getReportHeader(key), ":", " ", value});
    }

    private String _getRootDir() {
        Object rootDir = null;
        try {
            PersistenceManager persistenceManager = (PersistenceManager)_persistenceManagerSnapshot.get();
            String dlStoreConfigurationPid = "";
            if (StringUtil.equals((String)PropsValues.DL_STORE_IMPL, (String)"com.liferay.portal.store.file.system.AdvancedFileSystemStore")) {
                dlStoreConfigurationPid = _CONFIGURATION_PID_ADVANCED_FILE_SYSTEM_STORE;
            } else if (StringUtil.equals((String)PropsValues.DL_STORE_IMPL, (String)"com.liferay.portal.store.file.system.FileSystemStore")) {
                dlStoreConfigurationPid = _CONFIGURATION_PID_FILE_SYSTEM_STORE;
            }
            Dictionary configurations = persistenceManager.load(dlStoreConfigurationPid);
            if (configurations != null) {
                rootDir = (String)configurations.get("rootDir");
            }
            if (rootDir == null) {
                rootDir = PropsValues.LIFERAY_HOME + "/data/document_library";
            }
            return rootDir;
        }
        catch (IOException ioException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get document library store root dir", (Throwable)ioException);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Integer> _getTableCounts() {
        try (Connection connection = DataAccess.getConnection();){
            HashMap<String, Integer> hashMap;
            block28: {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                DBInspector dbInspector = new DBInspector(connection);
                ResultSet resultSet1 = databaseMetaData.getTables(dbInspector.getCatalog(), dbInspector.getSchema(), null, new String[]{"TABLE"});
                try {
                    HashMap<String, Integer> tableCounts = new HashMap<String, Integer>();
                    while (resultSet1.next()) {
                        String tableName = resultSet1.getString("TABLE_NAME");
                        try {
                            PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from " + tableName);
                            try {
                                ResultSet resultSet2 = preparedStatement.executeQuery();
                                try {
                                    if (!resultSet2.next()) continue;
                                    tableCounts.put(tableName, resultSet2.getInt(1));
                                }
                                finally {
                                    if (resultSet2 == null) continue;
                                    resultSet2.close();
                                }
                            }
                            finally {
                                if (preparedStatement == null) continue;
                                preparedStatement.close();
                            }
                        }
                        catch (SQLException sqlException) {
                            if (!_log.isWarnEnabled()) continue;
                            _log.warn((Object)("Unable to retrieve data from " + tableName), (Throwable)sqlException);
                        }
                    }
                    hashMap = tableCounts;
                    if (resultSet1 == null) break block28;
                }
                catch (Throwable throwable) {
                    if (resultSet1 != null) {
                        try {
                            resultSet1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet1.close();
            }
            return hashMap;
        }
        catch (SQLException sqlException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)sqlException);
            }
            return null;
        }
    }

    private void _printToLogContext(Map.Entry<String, Object> entry1) {
        Object value = entry1.getValue();
        if (value == null) {
            return;
        }
        String key = "upgrade.report." + entry1.getKey();
        if (value instanceof List) {
            StringBundler sb = new StringBundler("[");
            List list = (List)value;
            for (Object object : list) {
                if (object instanceof UpgradeSQLRecorder.FailedSQL) {
                    UpgradeSQLRecorder.FailedSQL failedSQL = (UpgradeSQLRecorder.FailedSQL)object;
                    sb.append(failedSQL.getSQL());
                    sb.append(":");
                    sb.append(failedSQL.getMessage());
                } else if (object instanceof UpgradeSQLRecorder.RunningSQL) {
                    UpgradeSQLRecorder.RunningSQL runningSQL = (UpgradeSQLRecorder.RunningSQL)object;
                    sb.append(runningSQL.getUpgradeProcessClassName());
                    sb.append(":");
                    sb.append(runningSQL.getSQL());
                    sb.append(":");
                    sb.append(runningSQL.getDuration());
                    sb.append(" ms");
                } else {
                    sb.append(String.valueOf(object));
                }
                sb.append(", ");
            }
            if (sb.length() > 1) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append("]");
            ThreadContext.put((String)key, (String)sb.toString());
        } else if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry entry2 : map.entrySet()) {
                ThreadContext.put((String)(key + "." + entry2.getKey()), (String)String.valueOf(entry2.getValue()));
            }
        } else {
            ThreadContext.put((String)key, (String)String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _printToLogContext(Map<String, Object> reportData) {
        if (!PropsValues.UPGRADE_LOG_CONTEXT_ENABLED) {
            return;
        }
        _logContext = true;
        try {
            for (Map.Entry<String, Object> entry1 : reportData.entrySet()) {
                this._printToLogContext(entry1);
            }
        }
        finally {
            _logContext = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeToFile(Map<String, Object> reportData, String reportFileName) {
        StringBundler sb = new StringBundler();
        for (Map.Entry<String, Object> entry1 : reportData.entrySet()) {
            Object value = entry1.getValue();
            if (value == null) continue;
            String key = entry1.getKey();
            if (value instanceof Collection) {
                String reportHeader = this._getReportHeader(key);
                sb.append(reportHeader);
                Collection objects = (Collection)value;
                if (objects.isEmpty()) {
                    sb.append(": Nothing registered\n");
                } else {
                    sb.append("\n");
                    sb.append(ListUtil.toString(Collections.nCopies(reportHeader.length(), "-"), (String)"null", (String)""));
                    sb.append("\n");
                    for (Object object : (Collection)value) {
                        sb.append(object.toString());
                        sb.append("\n");
                    }
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                for (Map.Entry entry2 : map.entrySet()) {
                    sb.append(this._getReportLine(key + "." + entry2.getKey(), entry2.getValue()));
                    sb.append("\n");
                }
            } else {
                sb.append(this._getReportLine(key, value));
                sb.append("\n");
            }
            sb.append("\n");
        }
        File reportFile = null;
        try {
            reportFile = this._getReportFile(reportFileName);
            FileUtil.write((File)reportFile, (String)StringUtil.merge((Object[])new String[]{sb.toString()}, (String)"\n\n"));
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Upgrade report generated in " + reportFile.getAbsolutePath()));
            }
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to generate the upgrade report in " + reportFile.getAbsolutePath()), (Throwable)ioException);
        }
        finally {
            if (PropsValues.UPGRADE_LOG_CONTEXT_ENABLED) {
                ThreadContext.clearMap();
            }
        }
    }

    static {
        _persistenceManagerSnapshot = new Snapshot(UpgradeReport.class, PersistenceManager.class);
        _releaseManagerSnapshot = new Snapshot(UpgradeReport.class, ReleaseManager.class);
    }

    private class DLSizeThread
    extends Thread {
        private DLSizeThread() {
        }

        @Override
        public void run() {
            UpgradeReport.this._dlSize = FileUtils.sizeOfDirectory((File)new File(UpgradeReport.this._rootDir));
        }
    }

    private class MessagesPrinter {
        private final String _className;
        private final List<MessagePrinter> _messagePrinters = new ArrayList<MessagePrinter>();

        public MessagesPrinter(String className) {
            this._className = className;
        }

        public void addMessagePrinter(String message, int occurrences) {
            this._messagePrinters.add(new MessagePrinter(message, occurrences));
        }

        public String toString() {
            if (_logContext) {
                return this._className + ":" + this._messagePrinters.toString();
            }
            StringBundler sb = new StringBundler();
            sb.append("Class name: ");
            sb.append(this._className);
            sb.append("\n");
            for (MessagePrinter messagePrinter : this._messagePrinters) {
                sb.append("\t");
                sb.append(messagePrinter.toString());
                sb.append("\n");
            }
            return sb.toString();
        }

        private class MessagePrinter {
            private final String _message;
            private final int _occurrences;

            public MessagePrinter(String message, int occurrences) {
                this._message = message;
                this._occurrences = occurrences;
            }

            public String toString() {
                if (_logContext) {
                    return this._occurrences + ":" + this._message;
                }
                return StringBundler.concat((Object[])new Object[]{this._occurrences, " occurrences of the following event: ", this._message});
            }
        }
    }

    private class TablePrinter {
        public static final String FORMAT = "%-30s %20s %20s";
        private final String _finalTableCount;
        private final String _initialTableCount;
        private final String _tableName;

        public TablePrinter(String finalTableCount, String initialTableCount, String tableName) {
            this._finalTableCount = finalTableCount;
            this._initialTableCount = initialTableCount;
            this._tableName = tableName;
        }

        public String toString() {
            if (_logContext) {
                return StringBundler.concat((String[])new String[]{this._tableName, ":", this._initialTableCount, ":", this._finalTableCount});
            }
            return String.format(FORMAT, this._tableName, this._initialTableCount, this._finalTableCount);
        }
    }

    private class RunningUpgradeProcess {
        private final String _timeDescription;
        private final String _upgradeProcessClassName;

        public RunningUpgradeProcess(String timeDescription, String upgradeProcessClassName) {
            this._timeDescription = timeDescription;
            this._upgradeProcessClassName = upgradeProcessClassName;
        }

        public String toString() {
            if (_logContext) {
                return StringBundler.concat((String[])new String[]{this._upgradeProcessClassName, ":", this._timeDescription, " ms"});
            }
            return StringBundler.concat((String[])new String[]{this._upgradeProcessClassName, " took ", this._timeDescription, " ms to complete\n"});
        }
    }

    private class PropertyPrinter {
        private final String _key;
        private final String _value;

        public PropertyPrinter(String key, String value) {
            this._key = key;
            this._value = ArrayUtil.contains((Object[])PropsValues.ADMIN_OBFUSCATED_PROPERTIES, (Object)key) ? "********" : value;
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }
}

