/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload.internal;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ClientDataRequestHelper;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadRequest;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Part;
import org.osgi.service.component.annotations.Component;

@Component(service={ClientDataRequestHelper.class})
public class ClientDataRequestHelperImpl
implements ClientDataRequestHelper {
    public Part getPart(String name, Object request, Portlet portlet) throws IOException, PortletException {
        UploadRequest uploadRequest = this._getUploadRequest(request);
        if (uploadRequest == null) {
            return null;
        }
        Map multipartParameterMap = uploadRequest.getMultipartParameterMap();
        FileItem[] fileItems = (FileItem[])multipartParameterMap.get(name);
        if (fileItems == null || fileItems.length == 0) {
            return null;
        }
        return new PartImpl(fileItems[0], portlet.getMultipartLocation());
    }

    public Collection<Part> getParts(Object request, Portlet portlet) throws IOException, PortletException {
        UploadRequest uploadRequest = this._getUploadRequest(request);
        if (uploadRequest == null) {
            return Collections.emptySet();
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        Map multipartParameterMap = uploadRequest.getMultipartParameterMap();
        for (Map.Entry entry : multipartParameterMap.entrySet()) {
            FileItem[] fileItems;
            for (FileItem fileItem : fileItems = (FileItem[])entry.getValue()) {
                parts.add(new PartImpl(fileItem, portlet.getMultipartLocation()));
            }
        }
        return parts;
    }

    private UploadRequest _getUploadRequest(Object request) {
        while (true) {
            if (request instanceof UploadRequest) {
                return (UploadRequest)request;
            }
            if (!(request instanceof ServletRequestWrapper)) break;
            ServletRequestWrapper servletRequestWrapper = (ServletRequestWrapper)request;
            request = servletRequestWrapper.getRequest();
        }
        return null;
    }

    private static final class PartImpl
    implements Part {
        private final FileItem _fileItem;
        private final String _multipartLocation;

        public void delete() throws IOException {
            this._fileItem.delete();
        }

        public String getContentType() {
            return this._fileItem.getContentType();
        }

        public String getHeader(String name) {
            return this._fileItem.getHeader(name);
        }

        public Collection<String> getHeaderNames() {
            return this._fileItem.getHeaderNames();
        }

        public Collection<String> getHeaders(String name) {
            return this._fileItem.getHeaders(name);
        }

        public InputStream getInputStream() throws IOException {
            return this._fileItem.getInputStream();
        }

        public String getName() {
            return this._fileItem.getFieldName();
        }

        public long getSize() {
            return this._fileItem.getSize();
        }

        public String getSubmittedFileName() {
            return this._fileItem.getFileName();
        }

        public void write(String fileName) throws IOException {
            if (Validator.isNull((String)fileName)) {
                throw new IOException("Invalid file name");
            }
            try {
                File multipartLocation;
                File file = new File(fileName);
                if (!file.isAbsolute() && Validator.isNotNull((String)this._multipartLocation) && (multipartLocation = new File(this._multipartLocation)).isDirectory()) {
                    file = new File(multipartLocation, fileName);
                }
                this._fileItem.write(file);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }

        private PartImpl(FileItem fileItem, String multipartLocation) {
            this._fileItem = fileItem;
            this._multipartLocation = multipartLocation;
        }
    }
}

