/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload.internal;

import com.liferay.petra.memory.DeleteFileFinalizeAction;
import com.liferay.petra.memory.FinalizeAction;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class LiferayFileItem
extends DiskFileItem
implements FileItem {
    private static final Log _log = LogFactoryUtil.getLog(LiferayFileItem.class);
    private static int _counter;
    private final String _encoding;
    private final String _fileName;
    private final int _sizeThreshold;
    private final File _tempDir;
    private File _tempFile;

    public LiferayFileItem(String fieldName, String contentType, boolean formField, String fileName, int sizeThreshold, File tempDir, String encoding) {
        super(fieldName, contentType, formField, fileName, sizeThreshold, tempDir);
        this._fileName = fileName;
        this._sizeThreshold = sizeThreshold;
        this._tempDir = tempDir;
        this._encoding = encoding;
    }

    public String getContentType() {
        try {
            return MimeTypesUtil.getContentType((InputStream)this.getInputStream(), (String)this.getFileName());
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            return "application/octet-stream";
        }
    }

    public String getFileName() {
        if (this._fileName == null) {
            return null;
        }
        int pos = this._fileName.lastIndexOf("/");
        if (pos == -1) {
            pos = this._fileName.lastIndexOf("\\");
        }
        if (pos == -1) {
            return this._fileName;
        }
        return this._fileName.substring(pos + 1);
    }

    public String getFileNameExtension() {
        return FileUtil.getExtension((String)this._fileName);
    }

    public String getFullFileName() {
        return this._fileName;
    }

    public String getHeader(String name) {
        FileItemHeaders fileItemHeaders = this.getHeaders();
        Iterator iterator = fileItemHeaders.getHeaders(name);
        if (iterator.hasNext()) {
            return (String)iterator.next();
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        ArrayList<String> headerNames = new ArrayList<String>();
        FileItemHeaders fileItemHeaders = this.getHeaders();
        Iterator iterator = fileItemHeaders.getHeaderNames();
        iterator.forEachRemaining(headerNames::add);
        return headerNames;
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        FileItemHeaders fileItemHeaders = this.getHeaders();
        Iterator iterator = fileItemHeaders.getHeaders(name);
        iterator.forEachRemaining(headers::add);
        return headers;
    }

    public int getSizeThreshold() {
        return this._sizeThreshold;
    }

    public String getString() {
        if (this.getSize() > THRESHOLD_SIZE) {
            return "";
        }
        if (this.isFormField() && this._encoding != null) {
            try {
                return super.getString(this._encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                _log.error((Throwable)unsupportedEncodingException);
            }
        }
        return super.getString();
    }

    public File getTempFile() {
        if (this._tempFile != null) {
            return this._tempFile;
        }
        String tempFileName = "upload_" + this._getUniqueId();
        String extension = this.getFileNameExtension();
        if (extension != null) {
            tempFileName = tempFileName + "." + extension;
        }
        this._tempFile = new File(this._tempDir, tempFileName);
        FinalizeManager.register((Object)this._tempFile, (FinalizeAction)new DeleteFileFinalizeAction(this._tempFile.getAbsolutePath()), (FinalizeManager.ReferenceFactory)FinalizeManager.PHANTOM_REFERENCE_FACTORY);
        return this._tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getUniqueId() {
        int current = 0;
        Class<LiferayFileItem> clazz = LiferayFileItem.class;
        synchronized (LiferayFileItem.class) {
            current = _counter++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String id = String.valueOf(current);
            if (current < 100000000) {
                return "00000000".substring(id.length()) + id;
            }
            return id;
        }
    }
}

