/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload.internal;

import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.upload.ServletFileUpload;
import com.liferay.portal.upload.internal.LiferayFileItemFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.osgi.service.component.annotations.Component;

@Component(service={ServletFileUpload.class})
public class ServletFileUploadImpl
implements ServletFileUpload {
    public List<com.liferay.portal.kernel.upload.FileItem> parseRequest(HttpServletRequest httpServletRequest, String location, int fileSizeThreshold) throws UploadException {
        ArrayList<com.liferay.portal.kernel.upload.FileItem> fileItems = new ArrayList<com.liferay.portal.kernel.upload.FileItem>();
        org.apache.commons.fileupload.servlet.ServletFileUpload servletFileUpload = new org.apache.commons.fileupload.servlet.ServletFileUpload((FileItemFactory)new LiferayFileItemFactory(new File(location), fileSizeThreshold, httpServletRequest.getCharacterEncoding()));
        long fileMaxSize = DLValidatorUtil.getMaxAllowableSize((long)0L, null);
        servletFileUpload.setFileSizeMax(fileMaxSize);
        servletFileUpload.setSizeMax(fileMaxSize);
        try {
            for (FileItem fileItem : servletFileUpload.parseRequest(httpServletRequest)) {
                fileItems.add((com.liferay.portal.kernel.upload.FileItem)fileItem);
            }
            return fileItems;
        }
        catch (FileUploadException fileUploadException) {
            UploadException uploadException = new UploadException((Throwable)fileUploadException);
            if (fileUploadException instanceof FileUploadBase.FileSizeLimitExceededException) {
                uploadException.setExceededFileSizeLimit(true);
            } else if (fileUploadException instanceof FileUploadBase.SizeLimitExceededException) {
                uploadException.setExceededUploadRequestSizeLimit(true);
            }
            throw uploadException;
        }
    }
}

