/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload.internal.configuration.persistence.listener;

import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upload.internal.configuration.UploadServletRequestConfiguration;
import java.io.File;
import java.util.Dictionary;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.upload.internal.configuration.UploadServletRequestConfiguration"}, service={ConfigurationModelListener.class})
public class UploadServletRequestConfigurationModelListener
implements ConfigurationModelListener {
    private static final long _MINIMUM_MAX_SIZE = 102400L;
    @Reference
    private Language _language;

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        File tempFile;
        long maxSize;
        Object maxSizeObject = properties.get("maxSize");
        if (maxSizeObject != null && (maxSize = ((Long)maxSizeObject).longValue()) < 102400L) {
            ResourceBundle resourceBundle = this._getResourceBundle();
            throw new ConfigurationModelListenerException(this._language.format(resourceBundle, "the-maximum-upload-request-size-cannot-be-less-than-x", (Object)this._language.formatStorageSize(GetterUtil.getDouble((Object)102400L), resourceBundle.getLocale())), UploadServletRequestConfiguration.class, this.getClass(), properties);
        }
        String tempDir = (String)properties.get("tempDir");
        if (Validator.isNotNull((String)tempDir) && !(tempFile = new File(tempDir)).exists()) {
            throw new ConfigurationModelListenerException(ResourceBundleUtil.getString((ResourceBundle)this._getResourceBundle(), (String)"please-enter-a-valid-temporary-storage-directory"), UploadServletRequestConfiguration.class, this.getClass(), properties);
        }
    }

    private ResourceBundle _getResourceBundle() {
        return ResourceBundleUtil.getBundle((Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass());
    }
}

