/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload.internal.configuration.persistence.listener;

import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.upload.internal.configuration.UploadServletRequestConfiguration;
import java.io.File;
import java.util.Dictionary;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.upload.internal.configuration.UploadServletRequestConfiguration"}, service={ConfigurationModelListener.class})
public class UploadServletRequestConfigurationModelListener
implements ConfigurationModelListener {
    private static final long _MINIMUM_MAX_SIZE = 102400L;

    public void onAfterSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        String tempDir = (String)properties.get("tempDir");
        if (Validator.isNull((String)tempDir)) {
            tempDir = SystemProperties.get((String)"java.io.tmpdir");
        }
        UploadServletRequestImpl.setTempDir((File)new File(tempDir));
    }

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        File tempFile;
        long maxSize = (Long)properties.get("maxSize");
        if (maxSize < 102400L) {
            ResourceBundle resourceBundle = this._getResourceBundle();
            throw new ConfigurationModelListenerException(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"the-maximum-upload-request-size-cannot-be-less-than-x", (Object)LanguageUtil.formatStorageSize((double)GetterUtil.getDouble((Object)102400L), (Locale)resourceBundle.getLocale())), UploadServletRequestConfiguration.class, this.getClass(), properties);
        }
        String tempDir = (String)properties.get("tempDir");
        if (Validator.isNotNull((String)tempDir) && !(tempFile = new File(tempDir)).exists()) {
            throw new ConfigurationModelListenerException(ResourceBundleUtil.getString((ResourceBundle)this._getResourceBundle(), (String)"please-enter-a-valid-temporary-storage-directory"), UploadServletRequestConfiguration.class, this.getClass(), properties);
        }
    }

    private ResourceBundle _getResourceBundle() {
        return ResourceBundleUtil.getBundle((Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass());
    }
}

