/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.url.builder.ComboRequestAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.internal.util.URLUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ComboRequestAbsolutePortalURLBuilderImpl
implements ComboRequestAbsolutePortalURLBuilder {
    private final String _cdnHost;
    private final Set<String> _filePaths = new LinkedHashSet<String>();
    private final HttpServletRequest _httpServletRequest;
    private final String _pathContext;
    private final String _pathProxy;
    private final Portal _portal;
    private long _timestamp;

    public ComboRequestAbsolutePortalURLBuilderImpl(String cdnHost, HttpServletRequest httpServletRequest, String pathContext, String pathProxy, Portal portal) {
        this._cdnHost = cdnHost;
        this._httpServletRequest = httpServletRequest;
        this._pathContext = pathContext;
        this._pathProxy = pathProxy;
        this._portal = portal;
    }

    public ComboRequestAbsolutePortalURLBuilder addFile(String filePath) {
        this._filePaths.add(URLUtil.removeParams(filePath));
        return this;
    }

    public String build() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        boolean cdnDynamicResourcesEnabled = this._portal.isCDNDynamicResourcesEnabled(themeDisplay.getCompanyId());
        String comboPath = this._portal.getStaticResourceURL(this._httpServletRequest, "/combo", "minifierType=js", this._timestamp);
        StringBundler sb = new StringBundler();
        URLUtil.appendURL(sb, this._cdnHost, !cdnDynamicResourcesEnabled, this._pathContext, this._pathProxy, comboPath);
        for (String filePath : this._filePaths) {
            sb.append("&");
            sb.append(filePath);
        }
        return sb.toString();
    }

    public ComboRequestAbsolutePortalURLBuilder setTimestamp(long timestamp) {
        this._timestamp = timestamp;
        return this;
    }
}

