/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.servlet.BrowserSnifferUtil;
import com.liferay.portal.url.builder.facet.BuildableAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.facet.CDNAwareAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.facet.CacheAwareAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.facet.PathProxyAwareAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.internal.util.CacheHelper;
import com.liferay.portal.url.builder.internal.util.URLUtil;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;

public abstract class BaseBundleResourceAbsolutePortalURLBuilderImpl<T>
implements BuildableAbsolutePortalURLBuilder,
CacheAwareAbsolutePortalURLBuilder<T>,
CDNAwareAbsolutePortalURLBuilder<T>,
PathProxyAwareAbsolutePortalURLBuilder<T> {
    private final Bundle _bundle;
    private final String _bundlePathPrefix;
    private final CacheHelper _cacheHelper;
    private CacheAwareAbsolutePortalURLBuilder.CachePolicy _cachePolicy = CacheAwareAbsolutePortalURLBuilder.CachePolicy.UNTIL_CHANGED;
    private final String _cdnHost;
    private final HttpServletRequest _httpServletRequest;
    private boolean _ignoreCDNHost;
    private boolean _ignorePathProxy;
    private final String _pathProxy;
    private final String _relativeURL;

    public BaseBundleResourceAbsolutePortalURLBuilderImpl(Bundle bundle, CacheHelper cacheHelper, String cdnHost, HttpServletRequest httpServletRequest, String pathModule, String pathProxy, String relativeURL) {
        if (!relativeURL.startsWith("/")) {
            relativeURL = "/" + relativeURL;
        }
        this._bundle = bundle;
        this._cacheHelper = cacheHelper;
        this._cdnHost = cdnHost;
        this._httpServletRequest = httpServletRequest;
        this._pathProxy = pathProxy;
        this._relativeURL = relativeURL;
        this._bundlePathPrefix = URLUtil.getBundlePathPrefix(bundle, pathModule);
    }

    public String build() {
        StringBundler sb = new StringBundler();
        URLUtil.appendURL(sb, this._cdnHost, this._ignoreCDNHost, this._ignorePathProxy, this._bundlePathPrefix, this._pathProxy, this._relativeURL);
        sb.append("?");
        this._cacheHelper.appendCacheParam(sb, this._bundle, this._cachePolicy, this._relativeURL);
        URLUtil.appendParam(sb, "browserId", BrowserSnifferUtil.getBrowserId((HttpServletRequest)this._httpServletRequest));
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        URLUtil.appendParam(sb, "languageId", themeDisplay.getLanguageId());
        this.addSpecificParams(this._httpServletRequest, sb);
        return sb.toString();
    }

    public T cache(CacheAwareAbsolutePortalURLBuilder.CachePolicy cachePolicy) {
        this._cachePolicy = cachePolicy;
        return (T)this;
    }

    public T ignoreCDNHost() {
        this._ignoreCDNHost = true;
        return (T)this;
    }

    public T ignorePathProxy() {
        this._ignorePathProxy = true;
        return (T)this;
    }

    protected abstract void addSpecificParams(HttpServletRequest var1, StringBundler var2);
}

