/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.portlet.PortletDependency;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.url.builder.PortletDependencyAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.internal.util.URLUtil;

public class PortletDependencyAbsolutePortalURLBuilderImpl
implements PortletDependencyAbsolutePortalURLBuilder {
    private final String _cdnHost;
    private final String _cssURN;
    private boolean _ignoreCDNHost;
    private final String _javaScriptURN;
    private final String _pathProxy;
    private final PortletDependency _portletDependency;

    public PortletDependencyAbsolutePortalURLBuilderImpl(String cdnHost, String cssURN, String javaScriptURN, String pathProxy, PortletDependency portletDependency) {
        this._cdnHost = cdnHost;
        this._cssURN = cssURN;
        this._javaScriptURN = javaScriptURN;
        this._pathProxy = pathProxy;
        this._portletDependency = portletDependency;
    }

    public String build() {
        String resourcePath;
        StringBundler relativeURLSB = new StringBundler(7);
        boolean ignoreCDNHost = this._ignoreCDNHost;
        boolean ignorePathProxy = false;
        if (PortletDependency.Type.CSS == this._portletDependency.getType()) {
            resourcePath = this._cssURN;
            if (Validator.isNull((String)resourcePath)) {
                resourcePath = "css";
            } else {
                ignoreCDNHost = true;
                ignorePathProxy = true;
            }
            relativeURLSB.append(resourcePath);
        } else if (PortletDependency.Type.JAVASCRIPT == this._portletDependency.getType()) {
            resourcePath = this._javaScriptURN;
            if (Validator.isNull((String)resourcePath)) {
                resourcePath = "js";
            } else {
                ignoreCDNHost = true;
                ignorePathProxy = true;
            }
            relativeURLSB.append(resourcePath);
        }
        if (Validator.isNotNull((String)this._portletDependency.getScope())) {
            relativeURLSB.append("/");
            relativeURLSB.append(this._portletDependency.getScope());
        }
        if (Validator.isNotNull((String)this._portletDependency.getVersion())) {
            relativeURLSB.append("/");
            relativeURLSB.append(this._portletDependency.getVersion());
        }
        relativeURLSB.append("/");
        relativeURLSB.append(this._portletDependency.getName());
        StringBundler sb = new StringBundler();
        URLUtil.appendURL(sb, this._cdnHost, ignoreCDNHost, ignorePathProxy, "", this._pathProxy, relativeURLSB.toString());
        return sb.toString();
    }

    public PortletDependencyAbsolutePortalURLBuilder ignoreCDNHost() {
        this._ignoreCDNHost = true;
        return this;
    }
}

