/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.url.builder.facet.CacheAwareAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.internal.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={CacheHelper.class})
public class CacheHelper {
    private static final String _NULL_HOLDER = "NULL_HOLDER";
    private static final Log _log = LogFactoryUtil.getLog(CacheHelper.class);
    private BundleContext _bundleContext;
    private BundleListener _bundleListener;
    private final Map<Long, Map<String, String>> _digests = new ConcurrentHashMap<Long, Map<String, String>>();
    private long _lastRestartTime;

    public void appendCacheParam(StringBundler sb, Bundle bundle, CacheAwareAbsolutePortalURLBuilder.CachePolicy cachePolicy, String resourcePath) {
        String mac;
        if (cachePolicy == CacheAwareAbsolutePortalURLBuilder.CachePolicy.NEVER) {
            this.appendNeverCacheParam(sb);
        } else if (cachePolicy == CacheAwareAbsolutePortalURLBuilder.CachePolicy.UNTIL_CHANGED && (mac = this._digest(bundle, "META-INF/resources" + resourcePath)) != null) {
            URLUtil.appendParam(sb, "mac", mac);
        }
    }

    public void appendLastRestartCacheParam(StringBundler sb) {
        URLUtil.appendParam(sb, "t", String.valueOf(this._lastRestartTime));
    }

    public void appendNeverCacheParam(StringBundler sb) {
        URLUtil.appendParam(sb, "t", String.valueOf(System.currentTimeMillis()));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._bundleListener = bundleEvent -> {
            if (bundleEvent.getType() == 4) {
                Bundle bundle = bundleEvent.getBundle();
                this._digests.remove(bundle.getBundleId());
            }
        };
        bundleContext.addBundleListener(this._bundleListener);
        this._lastRestartTime = System.currentTimeMillis();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleContext.removeBundleListener(this._bundleListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _digest(Bundle bundle, String path) {
        Map digests = this._digests.computeIfAbsent(bundle.getBundleId(), key -> new ConcurrentHashMap());
        String cacheKey = StringBundler.concat((Object[])new Object[]{bundle.getBundleId(), ":", path});
        String digest = (String)digests.get(cacheKey);
        if (digest != null) {
            if (digest != _NULL_HOLDER) return digest;
            return null;
        }
        URL url = bundle.getResource(path);
        if (url == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to find resource ", path, " inside bundle ", bundle.getSymbolicName()}));
            }
            digests.put(cacheKey, _NULL_HOLDER);
            return null;
        }
        try (InputStream inputStream = url.openStream();){
            digest = DigesterUtil.digestBase64((String)"SHA-1", (InputStream)inputStream);
            digests.put(cacheKey, digest);
            String string = digest;
            return string;
        }
        catch (IOException ioException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to digest resource ", path, " inside bundle ", bundle.getSymbolicName()}), (Throwable)ioException);
            }
            digests.put(cacheKey, _NULL_HOLDER);
            return null;
        }
    }
}

