/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import org.osgi.framework.Bundle;

public class URLUtil {
    public static void appendParam(StringBundler sb, String name, String value) {
        boolean hasQueryString = false;
        for (int i = 0; i < sb.index(); ++i) {
            String string = sb.stringAt(i);
            if (!string.contains("?")) continue;
            hasQueryString = true;
            break;
        }
        if (!hasQueryString) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append(name);
        sb.append("=");
        sb.append(value);
    }

    public static void appendURL(StringBundler sb, String cdnHost, boolean ignoreCDNHost, boolean ignorePathProxy, String pathPrefix, String pathProxy, String relativeURL) {
        if (!ignoreCDNHost && !Validator.isBlank((String)cdnHost)) {
            sb.append(cdnHost);
        }
        if (!ignorePathProxy) {
            sb.append(pathProxy);
        }
        if (!Validator.isBlank((String)pathPrefix)) {
            if (!pathPrefix.startsWith("/")) {
                sb.append("/");
            }
            if (pathPrefix.endsWith("/")) {
                sb.append(pathPrefix.substring(0, pathPrefix.length() - 1));
            } else {
                sb.append(pathPrefix);
            }
        }
        if (!relativeURL.startsWith("/")) {
            sb.append("/");
        }
        sb.append(relativeURL);
    }

    public static void appendURL(StringBundler sb, String cdnHost, boolean ignoreCDNHost, String pathPrefix, String pathProxy, String relativeURL) {
        URLUtil.appendURL(sb, cdnHost, ignoreCDNHost, false, pathPrefix, pathProxy, relativeURL);
    }

    public static void appendURL(StringBundler sb, String pathPrefix, String pathProxy, String relativeURL) {
        URLUtil.appendURL(sb, null, true, pathPrefix, pathProxy, relativeURL);
    }

    public static String getBundlePathPrefix(Bundle bundle, String pathModule) {
        Dictionary headers = bundle.getHeaders("");
        String webContextPath = (String)headers.get("Web-ContextPath");
        if (!webContextPath.endsWith("/")) {
            webContextPath = webContextPath + "/";
        }
        return pathModule + webContextPath;
    }

    public static String removeParams(String url) {
        int i = url.indexOf("?");
        if (i == -1) {
            return url;
        }
        return url.substring(0, i);
    }
}

