/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.url.builder.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.portlet.PortletDependency;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.ImageAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.MainAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.ModuleAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.PortletDependencyAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.ResourceAbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.WhiteboardAbsolutePortalURLBuilder;
import java.util.Dictionary;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;

public class AbsolutePortalURLBuilderImpl
implements AbsolutePortalURLBuilder {
    private static final Log _log = LogFactoryUtil.getLog(AbsolutePortalURLBuilderImpl.class);
    private final HttpServletRequest _httpServletRequest;
    private boolean _ignoreCDNHost;
    private boolean _ignorePathProxy;
    private final String _pathContext;
    private final String _pathImage;
    private final String _pathMain;
    private final String _pathModule;
    private final Portal _portal;

    public AbsolutePortalURLBuilderImpl(Portal portal, HttpServletRequest httpServletRequest) {
        this._portal = portal;
        this._httpServletRequest = httpServletRequest;
        String pathContext = portal.getPathContext();
        String pathProxy = portal.getPathProxy();
        this._pathContext = pathContext.substring(pathProxy.length());
        this._pathImage = this._pathContext + "/image";
        this._pathMain = this._pathContext + "/c";
        this._pathModule = this._pathContext + "/o";
    }

    public ImageAbsolutePortalURLBuilder forImage(final String relativeURL) {
        return new ImageAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(AbsolutePortalURLBuilderImpl.this._ignoreCDNHost, AbsolutePortalURLBuilderImpl.this._ignorePathProxy, AbsolutePortalURLBuilderImpl.this._pathImage, relativeURL);
            }
        };
    }

    public MainAbsolutePortalURLBuilder forMain(final String relativeURL) {
        return new MainAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(true, AbsolutePortalURLBuilderImpl.this._ignorePathProxy, AbsolutePortalURLBuilderImpl.this._pathMain, relativeURL);
            }
        };
    }

    public ModuleAbsolutePortalURLBuilder forModule(final Bundle bundle, final String relativeURL) {
        return new ModuleAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(AbsolutePortalURLBuilderImpl.this._ignoreCDNHost, AbsolutePortalURLBuilderImpl.this._ignorePathProxy, AbsolutePortalURLBuilderImpl.this._getBundlePathPrefix(bundle), relativeURL);
            }
        };
    }

    public ModuleAbsolutePortalURLBuilder forModuleScript(final Bundle bundle, final String relativeURL) {
        return new ModuleAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(AbsolutePortalURLBuilderImpl.this._ignoreCDNHost, AbsolutePortalURLBuilderImpl.this._ignorePathProxy, AbsolutePortalURLBuilderImpl.this._getBundlePathPrefix(bundle), relativeURL);
            }
        };
    }

    public ModuleAbsolutePortalURLBuilder forModuleStylesheet(final Bundle bundle, final String relativeURL) {
        return new ModuleAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(AbsolutePortalURLBuilderImpl.this._ignoreCDNHost, AbsolutePortalURLBuilderImpl.this._ignorePathProxy, AbsolutePortalURLBuilderImpl.this._getBundlePathPrefix(bundle), AbsolutePortalURLBuilderImpl.this._portal.getStaticResourceURL(AbsolutePortalURLBuilderImpl.this._httpServletRequest, relativeURL));
            }
        };
    }

    public PortletDependencyAbsolutePortalURLBuilder forPortletDependency(final PortletDependency portletDependency, final String cssURN, final String javaScriptURN) {
        return new PortletDependencyAbsolutePortalURLBuilder(){

            public String build() {
                StringBundler sb = new StringBundler(7);
                boolean ignoreCDNHost = AbsolutePortalURLBuilderImpl.this._ignoreCDNHost;
                boolean ignorePathProxy = AbsolutePortalURLBuilderImpl.this._ignorePathProxy;
                if (PortletDependency.Type.CSS == portletDependency.getType()) {
                    String resourcePath = cssURN;
                    if (Validator.isNull((String)resourcePath)) {
                        resourcePath = "css";
                    } else {
                        ignoreCDNHost = true;
                        ignorePathProxy = true;
                    }
                    sb.append(resourcePath);
                } else if (PortletDependency.Type.JAVASCRIPT == portletDependency.getType()) {
                    String resourcePath = javaScriptURN;
                    if (Validator.isNull((String)resourcePath)) {
                        resourcePath = "js";
                    } else {
                        ignoreCDNHost = true;
                        ignorePathProxy = true;
                    }
                    sb.append(resourcePath);
                }
                if (Validator.isNotNull((String)portletDependency.getScope())) {
                    sb.append("/");
                    sb.append(portletDependency.getScope());
                }
                if (Validator.isNotNull((String)portletDependency.getVersion())) {
                    sb.append("/");
                    sb.append(portletDependency.getVersion());
                }
                sb.append("/");
                sb.append(portletDependency.getName());
                return AbsolutePortalURLBuilderImpl.this._build(ignoreCDNHost, ignorePathProxy, "", sb.toString());
            }
        };
    }

    public ResourceAbsolutePortalURLBuilder forResource(final String relativeURL) {
        return new ResourceAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(AbsolutePortalURLBuilderImpl.this._ignoreCDNHost, AbsolutePortalURLBuilderImpl.this._ignorePathProxy, AbsolutePortalURLBuilderImpl.this._pathContext, relativeURL);
            }
        };
    }

    public WhiteboardAbsolutePortalURLBuilder forWhiteboard(final String servletPattern) {
        return new WhiteboardAbsolutePortalURLBuilder(){

            public String build() {
                return AbsolutePortalURLBuilderImpl.this._build(true, AbsolutePortalURLBuilderImpl.this._ignorePathProxy, AbsolutePortalURLBuilderImpl.this._pathModule, servletPattern);
            }
        };
    }

    public AbsolutePortalURLBuilder ignoreCDNHost() {
        this._ignoreCDNHost = true;
        return this;
    }

    public AbsolutePortalURLBuilder ignorePathProxy() {
        this._ignorePathProxy = true;
        return this;
    }

    private String _build(boolean ignoreCDNHost, boolean ignorePathProxy, String pathPrefix, String relativeURL) {
        StringBundler sb = new StringBundler(6);
        String cdnHost = this._getCDNHost(this._httpServletRequest);
        if (!ignoreCDNHost && !Validator.isBlank((String)cdnHost)) {
            sb.append(cdnHost);
        }
        if (!ignorePathProxy) {
            sb.append(this._getPathProxy());
        }
        if (!Validator.isBlank((String)pathPrefix)) {
            if (!pathPrefix.startsWith("/")) {
                sb.append("/");
            }
            if (pathPrefix.endsWith("/")) {
                sb.append(pathPrefix.substring(0, pathPrefix.length() - 1));
            } else {
                sb.append(pathPrefix);
            }
        }
        if (!relativeURL.startsWith("/")) {
            sb.append("/");
        }
        sb.append(relativeURL);
        return sb.toString();
    }

    private String _getBundlePathPrefix(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String webContextPath = (String)headers.get("Web-ContextPath");
        if (!webContextPath.endsWith("/")) {
            webContextPath = webContextPath + "/";
        }
        return this._pathModule + webContextPath;
    }

    private String _getCDNHost(HttpServletRequest httpServletRequest) {
        String cdnHost;
        block3: {
            try {
                cdnHost = this._portal.getCDNHost(httpServletRequest);
            }
            catch (PortalException portalException) {
                cdnHost = "";
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to retrieve CDN host from request", (Throwable)portalException);
            }
        }
        if (cdnHost.endsWith("/")) {
            cdnHost = cdnHost.substring(0, cdnHost.length() - 1);
        }
        return cdnHost;
    }

    private String _getPathProxy() {
        String pathProxy = this._portal.getPathProxy();
        if (!Validator.isBlank((String)pathProxy) && !pathProxy.startsWith("/")) {
            pathProxy = "/" + pathProxy;
        }
        if (pathProxy.endsWith("/")) {
            pathProxy = pathProxy.substring(0, pathProxy.length() - 1);
        }
        return pathProxy;
    }
}

