/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify.extender.internal.osgi.commands;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.output.stream.container.OutputStreamContainer;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactory;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactoryTracker;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.extender.internal.configuration.VerifyProcessTrackerConfiguration;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.verify.extender.internal.configuration.VerifyProcessTrackerConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"osgi.command.function=check", "osgi.command.function=checkAll", "osgi.command.function=execute", "osgi.command.function=executeAll", "osgi.command.function=help", "osgi.command.function=list", "osgi.command.function=show", "osgi.command.function=showReports", "osgi.command.scope=verify"}, service={VerifyProcessTrackerOSGiCommands.class})
public class VerifyProcessTrackerOSGiCommands {
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected IndexStatusManager indexStatusManager;
    @Reference
    protected OutputStreamContainerFactoryTracker outputStreamContainerFactoryTracker;
    @Reference
    protected ReleaseLocalService releaseLocalService;
    private static final Log _log = LogFactoryUtil.getLog(VerifyProcessTrackerOSGiCommands.class);
    private BundleContext _bundleContext;
    private Map<String, ServiceRegistration<Object>> _serviceRegistrations;
    private ServiceTrackerMap<String, List<VerifyProcess>> _verifyProcesses;
    private VerifyProcessTrackerConfiguration _verifyProcessTrackerConfiguration;

    @Descriptor(value="List latest execution result for a specific verify process")
    public void check(String verifyProcessName) {
        try {
            this._getVerifyProcesses(this._verifyProcesses, verifyProcessName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalArgumentException);
            }
            System.out.println("No verify process with name " + verifyProcessName);
            return;
        }
        Release release = this.releaseLocalService.fetchRelease(verifyProcessName);
        if (release == null || !release.isVerified() && release.getState() == 0) {
            System.out.println(verifyProcessName + " verify process has not executed");
        } else if (release.isVerified()) {
            System.out.println(verifyProcessName + " verify process succeeded");
        } else if (release.getState() == 2) {
            System.out.println(verifyProcessName + " verify process failed");
        }
    }

    @Descriptor(value="List latest execution result for all verify processes")
    public void checkAll() {
        for (String verifyProcessName : this._verifyProcesses.keySet()) {
            this.check(verifyProcessName);
        }
    }

    @Descriptor(value="Execute a specific verify process")
    public void execute(String verifyProcessName) {
        this._execute(this._verifyProcesses, verifyProcessName, null, true);
    }

    @Descriptor(value="Execute a specific verify process with a specific output")
    public void execute(String verifyProcessName, String outputStreamContainerFactoryName) {
        this._execute(this._verifyProcesses, verifyProcessName, outputStreamContainerFactoryName, true);
    }

    @Descriptor(value="Execute all verify processes")
    public void executeAll() {
        this._runAllVerifiersWithFactory(this.outputStreamContainerFactoryTracker.getOutputStreamContainerFactory(null), true);
    }

    @Descriptor(value="Execute all verify processes with a specific output")
    public void executeAll(String outputStreamContainerFactoryName) {
        this._runAllVerifiersWithFactory(this.outputStreamContainerFactoryTracker.getOutputStreamContainerFactory(outputStreamContainerFactoryName), true);
    }

    @Descriptor(value="List all registered verify processes")
    public void list() {
        for (String verifyProcessName : this._verifyProcesses.keySet()) {
            this.show(verifyProcessName);
        }
    }

    @Descriptor(value="Show all verify processes for a specific verify process name")
    public void show(String verifyProcessName) {
        try {
            this._getVerifyProcesses(this._verifyProcesses, verifyProcessName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalArgumentException);
            }
            System.out.println("No verify process with name " + verifyProcessName);
            return;
        }
        System.out.println("Registered verify process " + verifyProcessName);
    }

    @Descriptor(value="Show all available outputs")
    public void showReports() {
        Set outputStreamContainerFactoryNames = this.outputStreamContainerFactoryTracker.getOutputStreamContainerFactoryNames();
        for (String outputStreamContainerFactoryName : outputStreamContainerFactoryNames) {
            System.out.println(outputStreamContainerFactoryName);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        this._verifyProcessTrackerConfiguration = (VerifyProcessTrackerConfiguration)ConfigurableUtil.createConfigurable(VerifyProcessTrackerConfiguration.class, properties);
        VerifyServiceTrackerMapListener verifyServiceTrackerMapListener = null;
        if (this._verifyProcessTrackerConfiguration.autoVerify()) {
            verifyServiceTrackerMapListener = new VerifyServiceTrackerMapListener();
        }
        this._serviceRegistrations = new ConcurrentHashMap<String, ServiceRegistration<Object>>();
        this._verifyProcesses = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, VerifyProcess.class, null, (ServiceReferenceMapper)new PropertyServiceReferenceMapper("verify.process.name"), (Comparator)new PropertyServiceReferenceComparator("service.ranking"), (ServiceTrackerMapListener)verifyServiceTrackerMapListener);
    }

    @Deactivate
    protected void deactivate() {
        this._verifyProcesses.close();
        for (Map.Entry<String, ServiceRegistration<Object>> serviceRegistrationEntry : this._serviceRegistrations.entrySet()) {
            ServiceRegistration<Object> serviceRegistration = serviceRegistrationEntry.getValue();
            serviceRegistration.unregister();
        }
        this._serviceRegistrations = null;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private void _close(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _execute(ServiceTrackerMap<String, List<VerifyProcess>> verifyProcessTrackerMap, String verifyProcessName, String outputStreamContainerFactoryName, boolean force) {
        this._executeVerifyProcesses(verifyProcessTrackerMap, verifyProcessName, outputStreamContainerFactoryName, "verify-" + verifyProcessName, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _executeVerifyProcesses(ServiceTrackerMap<String, List<VerifyProcess>> verifyProcessTrackerMap, String verifyProcessName, OutputStream outputStream, boolean force) {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        List<VerifyProcess> verifyProcesses = this._getVerifyProcesses(verifyProcessTrackerMap, verifyProcessName);
        NotificationThreadLocal.setEnabled((boolean)false);
        StagingAdvicesThreadLocal.setEnabled((boolean)false);
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            Release release = this.releaseLocalService.fetchRelease(verifyProcessName);
            if (release != null && !force && release.isVerified()) {
                if (!this._serviceRegistrations.containsKey(verifyProcessName)) {
                    this._registerMarkerObject(verifyProcessName);
                }
                return;
            }
            if (release == null) {
                release = this.releaseLocalService.createRelease(this.counterLocalService.increment());
                release.setServletContextName(verifyProcessName);
                release.setVerified(false);
            }
            printWriter.println("Executing verifiers registered for " + verifyProcessName);
            VerifyException verifyException1 = null;
            for (VerifyProcess verifyProcess : verifyProcesses) {
                try {
                    verifyProcess.verify();
                }
                catch (VerifyException verifyException2) {
                    _log.error((Throwable)verifyException2);
                    verifyException1 = verifyException2;
                }
            }
            if (verifyException1 == null) {
                release.setVerified(true);
                release.setState(0);
                this.releaseLocalService.updateRelease(release);
                this._registerMarkerObject(verifyProcessName);
            } else {
                release.setVerified(false);
                release.setState(2);
                this.releaseLocalService.updateRelease(release);
            }
        }
        finally {
            NotificationThreadLocal.setEnabled((boolean)true);
            StagingAdvicesThreadLocal.setEnabled((boolean)true);
            WorkflowThreadLocal.setEnabled((boolean)true);
        }
    }

    private void _executeVerifyProcesses(final ServiceTrackerMap<String, List<VerifyProcess>> verifyProcessTrackerMap, final String verifyProcessName, String outputStreamContainerFactoryName, String outputStreamName, final boolean force) {
        OutputStreamContainerFactory outputStreamContainerFactory = this.outputStreamContainerFactoryTracker.getOutputStreamContainerFactory(outputStreamContainerFactoryName);
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create(outputStreamName);
        final OutputStream outputStream = outputStreamContainer.getOutputStream();
        this.outputStreamContainerFactoryTracker.runWithSwappedLog(new Runnable(){

            @Override
            public void run() {
                VerifyProcessTrackerOSGiCommands.this._executeVerifyProcesses((ServiceTrackerMap<String, List<VerifyProcess>>)verifyProcessTrackerMap, verifyProcessName, outputStream, force);
            }
        }, outputStreamName, outputStream);
        this._close(outputStream);
    }

    private List<VerifyProcess> _getVerifyProcesses(ServiceTrackerMap<String, List<VerifyProcess>> verifyProcessTrackerMap, String verifyProcessName) {
        List verifyProcesses = (List)verifyProcessTrackerMap.getService((Object)verifyProcessName);
        if (verifyProcesses == null) {
            throw new IllegalArgumentException("No verify processes with name " + verifyProcessName);
        }
        return verifyProcesses;
    }

    private void _registerMarkerObject(String verifyProcessName) {
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(Object.class, new Object(), (Dictionary)HashMapDictionaryBuilder.put((Object)"verify.process.name", (Object)verifyProcessName).build());
        this._serviceRegistrations.put(verifyProcessName, (ServiceRegistration<Object>)serviceRegistration);
    }

    private void _runAllVerifiersWithFactory(OutputStreamContainerFactory outputStreamContainerFactory, boolean force) {
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create("all-verifiers");
        OutputStream outputStream = outputStreamContainer.getOutputStream();
        this.outputStreamContainerFactoryTracker.runWithSwappedLog((Runnable)new AllVerifiersRunnable(outputStream, force), outputStreamContainer.getDescription(), outputStream);
    }

    private class VerifyServiceTrackerMapListener
    implements ServiceTrackerMapListener<String, VerifyProcess, List<VerifyProcess>> {
        private VerifyServiceTrackerMapListener() {
        }

        public void keyEmitted(ServiceTrackerMap<String, List<VerifyProcess>> verifyProcessTrackerMap, String key, VerifyProcess serviceVerifyProcess, List<VerifyProcess> contentVerifyProcesses) {
            VerifyProcessTrackerOSGiCommands.this._execute((ServiceTrackerMap<String, List<VerifyProcess>>)verifyProcessTrackerMap, key, "dummy", false);
        }

        public void keyRemoved(ServiceTrackerMap<String, List<VerifyProcess>> serviceTrackerMap, String key, VerifyProcess serviceVerifyProcess, List<VerifyProcess> contentVerifyProcess) {
        }
    }

    private class AllVerifiersRunnable
    implements Runnable {
        private final boolean _force;
        private final OutputStream _outputStream;

        public AllVerifiersRunnable(OutputStream outputStream, boolean force) {
            this._outputStream = outputStream;
            this._force = force;
        }

        @Override
        public void run() {
            Set verifyProcessNames = VerifyProcessTrackerOSGiCommands.this._verifyProcesses.keySet();
            for (String verifyProcessName : verifyProcessNames) {
                VerifyProcessTrackerOSGiCommands.this._executeVerifyProcesses((ServiceTrackerMap<String, List<VerifyProcess>>)VerifyProcessTrackerOSGiCommands.this._verifyProcesses, verifyProcessName, this._outputStream, this._force);
            }
        }
    }
}

