/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify.extender.internal.osgi.commands;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.gogo.shell.logging.TeeLoggingUtil;
import com.liferay.osgi.service.tracker.collections.EagerServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.upgrade.log.UpgradeLogContext;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(property={"osgi.command.function=check", "osgi.command.function=checkAll", "osgi.command.function=execute", "osgi.command.function=executeAll", "osgi.command.function=help", "osgi.command.function=list", "osgi.command.function=show", "osgi.command.scope=verify"}, service={})
public class VerifyProcessTrackerOSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(VerifyProcessTrackerOSGiCommands.class);
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    private ServiceRegistration<?> _serviceRegistration;
    private ServiceTrackerMap<String, VerifyProcess> _serviceTrackerMap;

    @Descriptor(value="List latest execution result for a module's verify process by symbolic name")
    public void check(String bundleSymbolicName) {
        VerifyProcess verifyProcess;
        try {
            verifyProcess = this._getVerifyProcess(this._serviceTrackerMap, bundleSymbolicName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalArgumentException);
            }
            System.out.println("No verify process exists for " + bundleSymbolicName);
            return;
        }
        String message = "Verify process " + ClassUtil.getClassName((Object)verifyProcess);
        Release release = this._fetchRelease(verifyProcess);
        if (release == null || !release.isVerified() && release.getState() == 0) {
            System.out.println(message + " was not executed");
        } else if (release.isVerified()) {
            System.out.println(message + " succeeded");
        } else if (release.getState() == 2) {
            System.out.println(message + " failed");
        }
    }

    @Descriptor(value="List latest execution result for all verify processes")
    public void checkAll() {
        for (String bundleSymbolicName : this._serviceTrackerMap.keySet()) {
            this.check(bundleSymbolicName);
        }
    }

    @Descriptor(value="Execute a module's verify process by symbolic name")
    public void execute(String bundleSymbolicName) {
        TeeLoggingUtil.runWithTeeLogging(() -> {
            VerifyProcess verifyProcess = this._getVerifyProcess(this._serviceTrackerMap, bundleSymbolicName);
            this._executeVerifyProcess(verifyProcess, this._fetchRelease(verifyProcess));
        });
    }

    @Descriptor(value="Execute all verify processes")
    public void executeAll() {
        TeeLoggingUtil.runWithTeeLogging(() -> {
            for (String bundleSymbolicName : this._serviceTrackerMap.keySet()) {
                VerifyProcess verifyProcess = this._getVerifyProcess(this._serviceTrackerMap, bundleSymbolicName);
                this._executeVerifyProcess(verifyProcess, this._fetchRelease(verifyProcess));
            }
        });
    }

    @Descriptor(value="List all registered verify processes")
    public void list() {
        for (String bundleSymbolicName : this._serviceTrackerMap.keySet()) {
            this.show(bundleSymbolicName);
        }
    }

    @Descriptor(value="Show the verify process class name by a module's symbolic name")
    public void show(String bundleSymbolicName) {
        VerifyProcess verifyProcess;
        try {
            verifyProcess = this._getVerifyProcess(this._serviceTrackerMap, bundleSymbolicName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalArgumentException);
            }
            System.out.println("No verify process exists for " + bundleSymbolicName);
            return;
        }
        System.out.println(StringBundler.concat((String[])new String[]{"Registered verify process ", ClassUtil.getClassName((Object)verifyProcess), " for module ", bundleSymbolicName}));
    }

    @Activate
    protected void activate(final BundleContext bundleContext, Map<String, Object> properties) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, VerifyProcess.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, VerifyProcess>(){

            public void map(ServiceReference<VerifyProcess> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
                Bundle bundle = serviceReference.getBundle();
                emitter.emit((Object)bundle.getSymbolicName());
            }
        }, (ServiceTrackerCustomizer)new EagerServiceTrackerCustomizer<VerifyProcess, VerifyProcess>(){

            public VerifyProcess addingService(ServiceReference<VerifyProcess> serviceReference) {
                VerifyProcess verifyProcess = (VerifyProcess)bundleContext.getService(serviceReference);
                Release release = VerifyProcessTrackerOSGiCommands.this._fetchRelease(verifyProcess);
                boolean initialDeployment = VerifyProcessTrackerOSGiCommands.this._isInitialDeployment(bundleContext, release);
                if (!initialDeployment && !release.isVerified() || GetterUtil.getBoolean((Object)serviceReference.getProperty("initial.deployment")) && initialDeployment || StartupHelperUtil.isUpgrading() && GetterUtil.getBoolean((Object)serviceReference.getProperty("run.on.portal.upgrade"))) {
                    VerifyProcessTrackerOSGiCommands.this._executeVerifyProcess(verifyProcess, release);
                } else if (release == null && !VerifyProcessTrackerOSGiCommands.this._isServiceBundle(serviceReference.getBundle())) {
                    release = VerifyProcessTrackerOSGiCommands.this._releaseLocalService.createRelease(VerifyProcessTrackerOSGiCommands.this._counterLocalService.increment());
                    Bundle bundle = FrameworkUtil.getBundle(verifyProcess.getClass());
                    release.setServletContextName(bundle.getSymbolicName());
                    release.setVerified(true);
                    release.setState(0);
                    VerifyProcessTrackerOSGiCommands.this._releaseLocalService.updateRelease(release);
                }
                return verifyProcess;
            }

            public void modifiedService(ServiceReference<VerifyProcess> serviceReference, VerifyProcess verifyProcess) {
            }

            public void removedService(ServiceReference<VerifyProcess> serviceReference, VerifyProcess verifyProcess) {
                bundleContext.ungetService(serviceReference);
            }
        });
        HashMapDictionary osgiCommandProperties = new HashMapDictionary();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("osgi.command.")) continue;
            osgiCommandProperties.put(key, entry.getValue());
        }
        this._serviceRegistration = bundleContext.registerService(VerifyProcessTrackerOSGiCommands.class, (Object)this, (Dictionary)osgiCommandProperties);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
        this._serviceTrackerMap.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _executeVerifyProcess(VerifyProcess verifyProcess, Release release) {
        NotificationThreadLocal.setEnabled((boolean)false);
        StagingAdvicesThreadLocal.setEnabled((boolean)false);
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            Bundle bundle = FrameworkUtil.getBundle(verifyProcess.getClass());
            if (release == null && !this._isServiceBundle(bundle)) {
                release = this._releaseLocalService.createRelease(this._counterLocalService.increment());
                release.setServletContextName(bundle.getSymbolicName());
                release.setVerified(false);
            }
            System.out.println("Executing verify " + ClassUtil.getClassName((Object)verifyProcess));
            try {
                UpgradeLogContext.setContext((String)bundle.getSymbolicName());
                verifyProcess.verify();
                if (release != null) {
                    release.setVerified(true);
                    release.setState(0);
                }
            }
            catch (VerifyException verifyException) {
                _log.error((Throwable)verifyException);
                if (release != null) {
                    release.setVerified(false);
                    release.setState(2);
                }
            }
            finally {
                UpgradeLogContext.clearContext();
            }
            if (release != null) {
                this._releaseLocalService.updateRelease(release);
            }
        }
        finally {
            NotificationThreadLocal.setEnabled((boolean)true);
            StagingAdvicesThreadLocal.setEnabled((boolean)true);
            WorkflowThreadLocal.setEnabled((boolean)true);
        }
    }

    private Release _fetchRelease(VerifyProcess verifyProcess) {
        Bundle bundle = FrameworkUtil.getBundle(verifyProcess.getClass());
        return this._releaseLocalService.fetchRelease(bundle.getSymbolicName());
    }

    private VerifyProcess _getVerifyProcess(ServiceTrackerMap<String, VerifyProcess> verifyProcessTrackerMap, String bundleSymbolicName) {
        VerifyProcess verifyProcess = (VerifyProcess)verifyProcessTrackerMap.getService((Object)bundleSymbolicName);
        if (verifyProcess == null) {
            throw new IllegalArgumentException("No verify processes exists for " + bundleSymbolicName);
        }
        return verifyProcess;
    }

    private boolean _isInitialDeployment(BundleContext bundleContext, Release release) {
        if (release == null) {
            return true;
        }
        try {
            Collection releases = bundleContext.getServiceReferences(Release.class, "(&(release.bundle.symbolic.name=" + release.getBundleSymbolicName() + ")(release.initial=true))");
            if (!releases.isEmpty()) {
                return true;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException(invalidSyntaxException);
        }
        return false;
    }

    private boolean _isServiceBundle(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        return headers.get("Liferay-Service") != null || headers.get("Liferay-Spring-Context") != null;
    }
}

