/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify.test.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.test.rule.Inject;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.test.util.BaseVerifyProcessTestCase;
import javax.portlet.PortletPreferences;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class BaseCompanySettingsVerifyProcessTestCase
extends BaseVerifyProcessTestCase {
    @Inject
    protected CompanyLocalService companyLocalService;
    @Inject
    protected PrefsProps prefsProps;
    @Inject
    protected SettingsFactory settingsFactory;
    private static final Log _log = LogFactoryUtil.getLog(BaseCompanySettingsVerifyProcessTestCase.class);
    private static BundleContext _bundleContext;

    @BeforeClass
    public static void setUpClass() {
        Bundle bundle = FrameworkUtil.getBundle(BaseCompanySettingsVerifyProcessTestCase.class);
        _bundleContext = bundle.getBundleContext();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        UnicodeProperties unicodeProperties = new UnicodeProperties();
        this.populateLegacyProperties(unicodeProperties);
        this.companyLocalService.forEachCompanyId(companyId -> this.companyLocalService.updatePreferences(companyId.longValue(), unicodeProperties));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.companyLocalService.forEachCompanyId(companyId -> {
            Settings settings = this.getSettings((long)companyId);
            ModifiableSettings modifiableSettings = settings.getModifiableSettings();
            modifiableSettings.reset();
            modifiableSettings.store();
        });
        super.tearDown();
    }

    @Override
    protected void doVerify() throws VerifyException {
        super.doVerify();
        this.companyLocalService.forEachCompanyId(companyId -> {
            PortletPreferences portletPreferences = this.prefsProps.getPreferences(companyId.longValue(), true);
            Settings settings = this.getSettings((long)companyId);
            Assert.assertNotNull((Object)settings);
            this.doVerify(portletPreferences, settings);
        });
    }

    protected abstract void doVerify(PortletPreferences var1, Settings var2);

    protected Settings getSettings(long companyId) {
        try {
            return this.settingsFactory.getSettings((SettingsLocator)new CompanyServiceSettingsLocator(companyId, this.getSettingsId()));
        }
        catch (SettingsException settingsException) {
            throw new IllegalStateException(settingsException);
        }
    }

    protected abstract String getSettingsId();

    @Override
    protected VerifyProcess getVerifyProcess() {
        try {
            Object[] serviceReferences = _bundleContext.getServiceReferences(VerifyProcess.class.getName(), StringBundler.concat((String[])new String[]{"(&(objectClass=", VerifyProcess.class.getName(), ")(verify.process.name=", this.getVerifyProcessName(), "))"}));
            if (ArrayUtil.isEmpty((Object[])serviceReferences)) {
                throw new IllegalStateException("Unable to get verify process");
            }
            return (VerifyProcess)_bundleContext.getService((ServiceReference)serviceReferences[0]);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            throw new IllegalStateException("Unable to get verify process");
        }
    }

    protected abstract String getVerifyProcessName();

    protected abstract void populateLegacyProperties(UnicodeProperties var1);
}

