/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.extension.validation;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import com.liferay.portal.vulcan.extension.validation.PropertyValidator;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.Set;
import javax.validation.ValidationException;

public class DefaultPropertyValidator
implements PropertyValidator {
    private static final Log _log = LogFactoryUtil.getLog(DefaultPropertyValidator.class);

    @Override
    public void validate(PropertyDefinition propertyDefinition, Object propertyValue) {
        PropertyDefinition.PropertyType propertyType;
        boolean valid;
        block15: {
            valid = false;
            Set<Class<?>> classes = propertyDefinition.getPropertyClasses();
            propertyType = propertyDefinition.getPropertyType();
            if (propertyType == PropertyDefinition.PropertyType.DATE_TIME) {
                if (propertyValue instanceof String) {
                    try {
                        LocalDateTime.parse((String)propertyValue, DateTimeFormatter.ofPattern(this._getDateTimePattern((String)propertyValue)));
                        valid = true;
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        if (!_log.isDebugEnabled()) break block15;
                        _log.debug((Throwable)dateTimeParseException);
                    }
                }
            } else if (propertyType == PropertyDefinition.PropertyType.MULTIPLE_ELEMENT) {
                Class<?> propertyValueClass = propertyValue.getClass();
                if (classes != null && propertyValueClass.isArray()) {
                    valid = true;
                    for (Object object : (Object[])propertyValue) {
                        if (this._isReadable(classes, object)) continue;
                        valid = false;
                        break;
                    }
                }
            } else if (propertyType == PropertyDefinition.PropertyType.SINGLE_ELEMENT) {
                if (classes != null && propertyValue instanceof Map && this._isReadable(classes, propertyValue)) {
                    valid = true;
                }
            } else if (classes != null) {
                for (Class<?> clazz : classes) {
                    if (!clazz.isInstance(propertyValue)) continue;
                    valid = true;
                    break;
                }
            }
        }
        if (!valid) {
            throw new ValidationException(StringBundler.concat((Object[])new Object[]{"The property name \"", propertyDefinition.getPropertyName(), "\" is invalid for property type ", propertyType}));
        }
    }

    private String _getDateTimePattern(String value) {
        if (value.length() == 16) {
            return "yyyy-MM-dd HH:mm";
        }
        if (value.length() == 20) {
            return "yyyy-MM-dd'T'HH:mm:ss'Z'";
        }
        if (value.length() == 21) {
            return "yyyy-MM-dd HH:mm:ss.S";
        }
        if (value.length() == 23 && value.charAt(10) == 'T') {
            return "yyyy-MM-dd'T'HH:mm:ss.SSS";
        }
        if (value.length() == 24 && value.charAt(10) == 'T') {
            return "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        }
        return "yyyy-MM-dd'T'HH:mm:ssZ";
    }

    private boolean _isReadable(Set<Class<?>> classes, Object object) {
        for (Class<?> clazz : classes) {
            if (ObjectMapperUtil.readValue(clazz, object) == null) continue;
            return true;
        }
        return false;
    }
}

