/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.liferay.petra.function.transform.TransformUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VulcanPropertyFilter
extends SimpleBeanPropertyFilter
implements PropertyFilter {
    private final Set<String> _fieldNames;
    private final Set<String> _restrictFieldNames;

    public static VulcanPropertyFilter of(Set<String> fieldNames, Set<String> restrictFieldNames) {
        return new VulcanPropertyFilter(fieldNames, restrictFieldNames);
    }

    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyWriter propertyWriter) throws Exception {
        if (!this.include(propertyWriter)) {
            return;
        }
        if (this._shouldWrite(jsonGenerator, propertyWriter)) {
            propertyWriter.serializeAsField(object, jsonGenerator, serializerProvider);
        }
    }

    private VulcanPropertyFilter(Set<String> fieldNames, Set<String> restrictFieldNames) {
        this._fieldNames = fieldNames == null ? new HashSet<String>() : fieldNames;
        this._restrictFieldNames = restrictFieldNames == null ? new HashSet<String>() : restrictFieldNames;
    }

    private boolean _isFiltered(String path) {
        return (this._fieldNames.isEmpty() || this._fieldNames.contains(path)) && !this._restrictFieldNames.contains(path);
    }

    private boolean _isFilteredWithoutNested(String path) {
        if (this._isFiltered(path)) {
            for (String fieldName : this._fieldNames) {
                if (!fieldName.startsWith(path + ".")) continue;
                return false;
            }
            for (String restrictFieldName : this._restrictFieldNames) {
                if (!restrictFieldName.startsWith(path + ".")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean _shouldWrite(JsonGenerator jsonGenerator, PropertyWriter propertyWriter) {
        List<String> paths = this._toPaths(jsonGenerator, propertyWriter.getName());
        String firstPath = paths.get(0);
        if (this._isFiltered(firstPath)) {
            return true;
        }
        if (paths.size() == 1) {
            return false;
        }
        for (int i = 1; i < paths.size(); ++i) {
            if (!this._isFilteredWithoutNested(paths.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<String> _toPaths(JsonGenerator jsonGenerator, String name) {
        String currentName;
        List<String> paths = new ArrayList<String>();
        paths.add(name);
        JsonStreamContext jsonStreamContext = jsonGenerator.getOutputContext();
        if (jsonStreamContext != null) {
            jsonStreamContext = jsonStreamContext.getParent();
        }
        while (!(jsonStreamContext == null || (currentName = jsonStreamContext.getCurrentName()) != null && currentName.contains("items"))) {
            if (currentName != null) {
                paths = TransformUtil.transform(paths, (currentName + ".")::concat);
                paths.add(currentName);
            }
            jsonStreamContext = jsonStreamContext.getParent();
        }
        return paths;
    }
}

