/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.jaxrs.extension;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExtendedEntity {
    private static final Log _log = LogFactoryUtil.getLog(ExtendedEntity.class);
    private final Object _entity;
    private final Map<String, Serializable> _extendedProperties;

    public static ExtendedEntity extend(Object entity, Map<String, Serializable> extendedProperties, Set<String> filteredPropertyKeys) {
        if (extendedProperties == null) {
            extendedProperties = Collections.emptyMap();
        }
        if (filteredPropertyKeys == null) {
            filteredPropertyKeys = Collections.emptySet();
        }
        return new ExtendedEntity(entity, extendedProperties, filteredPropertyKeys);
    }

    @JsonUnwrapped
    public Object getEntity() {
        return this._entity;
    }

    @JsonAnyGetter
    public Map<String, Serializable> getExtendedProperties() {
        return this._extendedProperties;
    }

    private ExtendedEntity(Object entity, Map<String, Serializable> extendedProperties, Set<String> filteredPropertyNames) {
        this._entity = entity;
        this._extendedProperties = new HashMap<String, Serializable>(extendedProperties);
        Set<String> extendedPropertyKeys = this._extendedProperties.keySet();
        extendedPropertyKeys.removeIf(Objects::isNull);
        for (String key : filteredPropertyNames) {
            this._extendedProperties.put(key, null);
        }
        for (Field field : this._getAllFields()) {
            if (!this._extendedProperties.containsKey(field.getName())) continue;
            try {
                field.setAccessible(true);
                field.set(this._entity, null);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
    }

    private Field[] _getAllFields() {
        ArrayList fields = new ArrayList();
        for (Class<?> clazz = this._entity.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Collections.addAll(fields, clazz.getDeclaredFields());
        }
        return fields.toArray(new Field[0]);
    }
}

