/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.batch.engine.Field;
import com.liferay.portal.vulcan.yaml.openapi.Components;
import com.liferay.portal.vulcan.yaml.openapi.Content;
import com.liferay.portal.vulcan.yaml.openapi.Get;
import com.liferay.portal.vulcan.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.vulcan.yaml.openapi.Operation;
import com.liferay.portal.vulcan.yaml.openapi.Parameter;
import com.liferay.portal.vulcan.yaml.openapi.PathItem;
import com.liferay.portal.vulcan.yaml.openapi.Post;
import com.liferay.portal.vulcan.yaml.openapi.Response;
import com.liferay.portal.vulcan.yaml.openapi.ResponseCode;
import com.liferay.portal.vulcan.yaml.openapi.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenAPIUtil {
    public static List<String> getCreateEntityScopes(String entityName, OpenAPIYAML openAPIYAML) {
        ArrayList<String> scopes = new ArrayList<String>();
        Map<String, PathItem> pathItemsMap = openAPIYAML.getPathItems();
        for (PathItem pathItem : pathItemsMap.values()) {
            String operationScope;
            Post post = pathItem.getPost();
            if (post == null || !OpenAPIUtil._hasOKResponseContentSchemaReferenceLike(entityName, post) || !Validator.isNotNull((String)(operationScope = OpenAPIUtil._getOperationScope(post)))) continue;
            scopes.add(operationScope);
        }
        return scopes;
    }

    public static Map<String, Field> getDTOEntityFields(String entityName, OpenAPIYAML openAPIYAML) {
        Components components = openAPIYAML.getComponents();
        Map<String, Schema> schemas = components.getSchemas();
        Schema schema = schemas.get(entityName);
        if (schema == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        List<String> requiredPropertySchemaNames = OpenAPIUtil._getRequiredPropertySchemaNames(schema);
        Map<String, Schema> propertySchemas = schema.getPropertySchemas();
        for (Map.Entry<String, Schema> schemaEntry : propertySchemas.entrySet()) {
            String propertyName = schemaEntry.getKey();
            Schema propertySchema = schemaEntry.getValue();
            fields.put(propertyName, Field.of(propertySchema.getDescription(), propertyName, propertySchema.isReadOnly(), requiredPropertySchemaNames.contains(propertyName), propertySchema.getType(), propertySchema.isWriteOnly()));
        }
        return fields;
    }

    public static List<String> getReadEntityScopes(String entityName, OpenAPIYAML openAPIYAML) {
        ArrayList<String> scopes = new ArrayList<String>();
        Map<String, PathItem> pathItemsMap = openAPIYAML.getPathItems();
        for (PathItem pathItem : pathItemsMap.values()) {
            String operationScope;
            Get get = pathItem.getGet();
            if (get == null || !OpenAPIUtil._hasOKResponseContentSchemaReferenceLike("Page" + entityName, get) || !Validator.isNotNull((String)(operationScope = OpenAPIUtil._getOperationScope(get)))) continue;
            scopes.add(operationScope);
        }
        return scopes;
    }

    private static String _getOperationScope(Operation operation) {
        List<Parameter> parameters = operation.getParameters();
        if (parameters.isEmpty()) {
            return null;
        }
        StringBundler sb = new StringBundler(parameters.size() * 2);
        for (Parameter parameter : parameters) {
            if (!StringUtil.equals((String)parameter.getIn(), (String)"path")) continue;
            String name = parameter.getName();
            if (name.endsWith("Id")) {
                name = StringUtil.removeLast((String)name, (String)"Id");
            }
            sb.append(name);
            sb.append(",");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private static List<String> _getRequiredPropertySchemaNames(Schema schema) {
        List<String> requiredPropertySchemaNames = schema.getRequiredPropertySchemaNames();
        if (requiredPropertySchemaNames == null) {
            requiredPropertySchemaNames = Collections.emptyList();
        }
        return requiredPropertySchemaNames;
    }

    private static boolean _hasOKResponseContentSchemaReferenceLike(String name, Operation operation) {
        Map<ResponseCode, Response> responses = operation.getResponses();
        if (responses == null) {
            return false;
        }
        for (Map.Entry<ResponseCode, Response> entry : responses.entrySet()) {
            if (!OpenAPIUtil._isOKResponseCode(entry.getKey())) continue;
            Response response = entry.getValue();
            Map<String, Content> contentMap = response.getContent();
            for (Map.Entry<String, Content> contentEntry : contentMap.entrySet()) {
                String reference;
                Content content = contentEntry.getValue();
                Schema schema = content.getSchema();
                if (schema == null || (reference = schema.getReference()) == null || !StringUtil.equals((String)name, (String)reference.substring(reference.lastIndexOf(47) + 1))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean _isOKResponseCode(ResponseCode responseCode) {
        return responseCode.isDefaultResponse() || responseCode.getHttpCode() / 100 == 2;
    }
}

